package com.tykj.dev.device.confirmcheck.entity.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * CheckDetailVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/17 at 8:46 下午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CheckDetailVo {


    /**
     * 主键id
     */
    @ApiModelProperty(name = "主键id")
    private Integer id;
    /**
     * 核查账单id
     */
    @ApiModelProperty(value = "核查账单id")
    private Integer finalCheckId;
    /**
     * 检查组成员1(省A岗) 名称
     */
    @ApiModelProperty(value = "检查组成员1(省A岗)名称")
    private String checkUserAName;
    /**
     * 检查组成员2(省A岗) 名称
     */
    @ApiModelProperty(value = "检查组成员2(省A岗)名称")
    private String checkUserBName;
    /**
     * 本级经办人名称(A岗)
     */
    @ApiModelProperty(value = "本级经办人名称(A岗)")
    private String userAName;
    /**
     * 本级审核人名称(B岗)
     */
    @ApiModelProperty(value = "本级审核人名称(B岗)")
    private String userBName;

    /**
     * 检查组成员1(省A岗)id
     */
    @ApiModelProperty(value = "检查组成员1(省A岗)id")
    private Integer checkUserAId;
    /**
     * 检查组成员2(省A岗)id
     */
    @ApiModelProperty(value = "检查组成员2(省A岗)id")
    private Integer checkUserBId;
    /**
     * 本级经办人id(A岗)
     */
    @ApiModelProperty(value = "本级经办人id(A岗)")
    private Integer userAId;
    /**
     * 本级审核人id(B岗)
     */
    @ApiModelProperty(value = "本级审核人id(B岗)")
    private Integer userBId;

    /**
     * 核查时间
     */
    @ApiModelProperty(value = "核查时间")
    private Date checkTime;
    /**
     * 核查单位
     */
    @ApiModelProperty(value = "核查单位")
    private String checkUnit;
    /**
     * 应查数量
     */
    @ApiModelProperty(value = "应查数量")
    private Integer checkingCount;
    /**
     * 实查数量
     */
    @ApiModelProperty(value = "实查数量")
    private Integer checkedCount;
    /**
     * 核查结果
     */
    @ApiModelProperty(value = "核查结果")
    private String checkResult;

    @ApiModelProperty(value = "在库装备列表")
    private List<DeviceInLibVo> devInLibrary;

    @ApiModelProperty(value = "非在库装备列表")
    private List<DeviceNotInLibVo> devNotInLibrary;
    /**
     * 核查状态(0:待核查,1:审核失败,2:核查完成)
     */
    @ApiModelProperty(value = "核查状态(0:待核查,1:审核失败,2:核查完成)")
    private Integer checkStatus;


}
