package com.tykj.dev.device.task.subject.common;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author dengdiyi
 */
public class GlobalMap {

    private static final Map<Integer, StatusEnum> statusEnumMap;

    private static final Map<Integer,RepairStatusEnum> repairStatusMap;

    static {
        statusEnumMap = Arrays.stream(StatusEnum.values())
                .collect(Collectors.toMap(statusEnum -> statusEnum.id, Function.identity()));
        repairStatusMap = Arrays.stream(RepairStatusEnum.values())
                .collect(Collectors.toMap(repairStatusEnum -> repairStatusEnum.id,Function.identity()));
    }

    public static Map<Integer, StatusEnum> getStatusEnumMap() {
        return statusEnumMap;
    }

    public static Map<Integer, RepairStatusEnum> getRepairStatusMap() {
        return repairStatusMap;
    }
}
