package com.tykj.dev.device.user.base.ret;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tykj.dev.device.user.subject.entity.User;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName MemberThat.java
 * @Description TODO
 * @createTime 2020年08月11日 20:21:00
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "专管员对象", description = "专管员记录")
@Builder
public class MemberThat {

    private Integer userId;
    /**
     * 真实名称
     */
    @ApiModelProperty(value = "真实名称", name = "name", example = "12321L")
    private String name;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码", name = "mPassWord", example = "12321L")
    private String password;

    /**
     * 用户名
     */
    @ApiModelProperty(value = "用户名", name = "userName", example = "12321L")
    private String username;
    /**
     * 排序
     */
    @ApiModelProperty(value = "排序", name = "showOrder", example = "12321L")
    private Integer showOrder;

    /**
     * 移动电话
     */
    @ApiModelProperty(value = "移动电话", name = "mobile", example = "12321L")
    private String mobile;

    /**
     * 机座
     */
    @ApiModelProperty(value = "机座", name = "telphone", example = "12321L")
    private String telphone;

    /**
     * 邮箱
     */
    @ApiModelProperty(value = "邮箱", name = "email", example = "12321L")
    private String email;

    /**
     * 真传
     */
    @ApiModelProperty(value = "真传", name = "fax", example = "12321L")
    private String fax;

    /**
     * 状态 默认0，1表示删除
     */
    @ApiModelProperty(value = "状态", name = "isDel", example = "12321L")
    private Integer isDel;

    /**
     * 身份证
     */
    @ApiModelProperty(value = "身份证", name = "idCard", example = "12321L")
    private String idCard;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别", name = "sex", example = "12321L")
    private Integer sex;

    /**
     * 用户单位
     */
    @ApiModelProperty(value = "用户单位", name = "unitsId", example = "12321L")
    private Integer unitsId;

    /**
     * 用户单位名称
     */
    @ApiModelProperty(value = "用户单位", name = "unitsId", example = "12321L")
    private String unitsName;

    /**
     * 职务
     */
    @ApiModelProperty(value = "用户职务",name = "position")
    private Integer position;
    /**
     * 培训状态 0.已培训 1.已过期 2.未培训 3.快过期
     */
    private Integer trainStatus;

    /**
     * 证书编号
     */
    @ApiModelProperty(value = "证书编号", name = "certNum", example = "12321L")
    private Integer certNum;
    /**
     * 颁发日期
     */
    @ApiModelProperty(value = "颁发日期", name = "issueDate", example = "12321L")
    private Date issueDate;
    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期", name = "expiryDate", example = "12321L")
    private Date expiryDate;
    /**
     *是否失效 默认0 1失效
     *
     */
    @ApiModelProperty(value = "是否失效 默认0 1失效", name = "isExpiry", example = "12321L")
    private Integer isExpiry;
    /**
     * 证书名称
     */
    @ApiModelProperty(value = "证书名称", name = "certName", example = "12321L")
    private String certName;

    /**
     * 剩余时间 long
     */
    @JsonIgnore
    private Long remaining;

    public User toUserVo(){
        ModelMapper mapper= BeanHelper.getUserMapper();
        return mapper.map(this, User.class);
    }

}
