/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.sdk.printer.internal;

import com.zebra.sdk.comm.Connection;
import com.zebra.sdk.comm.ConnectionException;
import com.zebra.sdk.printer.SGD;
import com.zebra.sdk.util.internal.RegexUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;

public class FirmwareUtil {
    public static String extractFirmwareVersion(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        int n = 5;
        try {
            String string2;
            List<String> list;
            String string3 = null;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
                if (++n2 < n) continue;
            }
            if ((list = RegexUtil.getMatches(string2 = "^\\s*! PROGRAM\\s*(.*?)\\s*~D[C|I]", stringBuffer.toString())).size() == 2) {
                string = list.get(1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public static boolean firmwareVersionsDontMatch(InputStream inputStream, Connection connection) throws ConnectionException {
        String string = FirmwareUtil.getFWVersionFromPrinterConnection(connection).trim().toLowerCase();
        boolean bl = FirmwareUtil.firmwareVersionsDontMatch(inputStream, string);
        return bl;
    }

    public static boolean firmwareVersionsDontMatch(InputStream inputStream, String string) {
        String string2 = FirmwareUtil.extractFirmwareVersion(inputStream).trim();
        boolean bl = FirmwareUtil.firmwareVersionsMatch(string2, string);
        return false == bl;
    }

    public static String getFWVersionFromPrinterConnection(Connection connection) throws ConnectionException {
        String string = SGD.GET("appl.name", connection);
        return string;
    }

    public static boolean firmwareVersionsMatch(String string, String string2) {
        String string3 = string.trim().toLowerCase();
        String string4 = string2.trim().toLowerCase();
        boolean bl = string4.equals(string3) || FirmwareUtil.matchIgnoringZ(string3, string4);
        return bl;
    }

    private static boolean matchIgnoringZ(String string, String string2) {
        return string2.replaceAll("z", "").equals(string.replaceAll("z", ""));
    }
}

