package com.tykj.dev.device.allot.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.allot.service.AllotBackBillService;
import com.tykj.dev.device.allot.service.AllotBillService;
import com.tykj.dev.device.allot.subject.domin.AllotBackBill;
import com.tykj.dev.device.allot.subject.domin.AllotBill;
import com.tykj.dev.device.allot.subject.vo.AllotBillSelectVo;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.user.subject.service.UserPublicService;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.misc.utils.StringSplitUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
@RestController
@Api(tags = "业务模块", description = "业务模块")
@AutoDocument
@RequestMapping("/business")
public class AllotBillSelectController {

    @Autowired
    private AllotBillService allotBillService;

    @Autowired
    private UserPublicService userService;

    @Autowired
    private DeviceLibraryService deviceLibraryService;

    @Autowired
    private AllotBackBillService allotBackBillService;

    @Autowired
    private TaskService taskService;

    @ApiOperation(value = "查询配发单", notes = "可以通过这个接口查询配发单")
    @PostMapping(value = "/archives/allot/summary")
    public ResponseEntity selectAllotBill(@RequestBody AllotBillSelectVo allotBillSelectVo) {
        Page<AllotBill> page = allotBillService.getPage(allotBillSelectVo, allotBillSelectVo.getPageable());
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value = "查询退回单", notes = "可以通过这个接口查询退回单")
    @PostMapping(value = "/archives/back/summary")
    public ResponseEntity selectBackBill(@RequestBody AllotBillSelectVo allotBillSelectVo) {
        Page<AllotBackBill> page = allotBackBillService.getPage(allotBillSelectVo, allotBillSelectVo.getPageable());
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value = "查询配发单详情页,通过billId查询", notes = "可以通过这个接口查询配发单")
    @GetMapping(value = "/archives/allot/detail/{id}")
    public ResponseEntity selectAllotBillDetail(@PathVariable("id") int id) {
        //获取所有装备id map
        Map<Integer,DeviceLibrary> deviceLibraryMap = deviceLibraryService.getAllDeviceMap();
        //返回的数组
        List<Object> list = new ArrayList<>();
//        Integer billId = taskService.get(id).getBillId();
        //set账单用户名称并添加
        AllotBill allotBillEntity = allotBillService.getOne(id);
        if (allotBillEntity.getSendUseraId() != null){
            allotBillEntity.setSenderUserA(userService.getOne(allotBillEntity.getSendUseraId()).getName());
        }
        if (allotBillEntity.getSendUserbId() != null){
            allotBillEntity.setSenderUserB(userService.getOne(allotBillEntity.getSendUserbId()).getName());
        }
        if (allotBillEntity.getReceiveUseraId() != null) {
            allotBillEntity.setReceiveUserA(userService.getOne(allotBillEntity.getReceiveUseraId()).getName());
        }
        if (allotBillEntity.getReceiveUserbId() != null) {
            allotBillEntity.setReceiveUserB(userService.getOne(allotBillEntity.getReceiveUserbId()).getName());
        }
        //转换文件
        allotBillEntity.setSendFileList(FilesUtil.stringFileToList(allotBillEntity.getSendFiles()));
        allotBillEntity.setReceiveFileList(FilesUtil.stringFileToList(allotBillEntity.getReceiveFiles()));
        allotBillEntity.setReplyFileList(FilesUtil.stringFileToList(allotBillEntity.getReplyFiles()));
        allotBillEntity.setApplyFileList(FilesUtil.stringFileToList(allotBillEntity.getApplyFiles()));
        //转换单据
        if (allotBillEntity.getScriptJson()!=null){
            allotBillEntity.setScripts(JacksonUtil.readValue(allotBillEntity.getScriptJson(),new TypeReference<List<ScriptSaveVo>>() {}));
        }
        list.add(allotBillEntity);
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        //如果接收装备详情不为空，分隔装备id并添加
        if (allotBillEntity.getAllotCheckDetail() != null) {
            for (Integer deviceId : StringSplitUtil.split(allotBillEntity.getAllotCheckDetail())) {
                libraryEntities.add(deviceLibraryMap.get(deviceId));
            }
        }
        list.add(libraryEntities);
        return ResponseEntity.ok(list);
    }

    @ApiOperation(value = "查询退回单详情页，通过billId查询", notes = "可以通过这个接口查询退回单")
    @GetMapping(value = "/archives/back/detail/{id}")
    public ResponseEntity selectBackBillDetail(@PathVariable("id") int id) {
        //获取所有装备id map
        Map<Integer,DeviceLibrary> deviceLibraryMap = deviceLibraryService.getAllDeviceMap();
        //返回的数组
        List<Object> list = new ArrayList<>();
        //set账单用户名称并添
//        Integer billId = taskService.get(id).getBillId();
        AllotBackBill allotBillEntity = allotBackBillService.getOne(id);
        if (allotBillEntity.getSendUseraId() != null) {
            allotBillEntity.setSenderUserA(userService.getOne(allotBillEntity.getSendUseraId()).getName());
        }
        if (allotBillEntity.getSendUserbId() != null) {
            allotBillEntity.setSenderUserB(userService.getOne(allotBillEntity.getSendUserbId()).getName());
        }
        if (allotBillEntity.getReceiveUseraId() != null) {
            allotBillEntity.setReceiveUserA(userService.getOne(allotBillEntity.getReceiveUseraId()).getName());
        }
        if (allotBillEntity.getReceiveUserbId() !=null){
            allotBillEntity.setReceiveUserB(userService.getOne(allotBillEntity.getReceiveUserbId()).getName());
        }
        //转换文件
        allotBillEntity.setSendFileList(FilesUtil.stringFileToList(allotBillEntity.getSendFiles()));
        allotBillEntity.setReceiveFileList(FilesUtil.stringFileToList(allotBillEntity.getReceiveFiles()));
        allotBillEntity.setReplyFileList(FilesUtil.stringFileToList(allotBillEntity.getReplyFiles()));
        allotBillEntity.setApplyFileList(FilesUtil.stringFileToList(allotBillEntity.getApplyFiles()));
        //转换单据
        if (allotBillEntity.getScriptJson()!=null){
            allotBillEntity.setScripts(JacksonUtil.readValue(allotBillEntity.getScriptJson(),new TypeReference<List<ScriptSaveVo>>() {}));
        }
        list.add(allotBillEntity);
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        //如果接收装备详情不为空，分隔装备id并添加
        if (allotBillEntity.getBackCheckDetail() != null) {
            for (Integer deviceId : StringSplitUtil.split(allotBillEntity.getBackCheckDetail())) {
                libraryEntities.add(deviceLibraryMap.get(deviceId));
            }
        }
        list.add(libraryEntities);
        return ResponseEntity.ok(list);
    }


    @ApiOperation(value = "查询配发单详情页，通过taskId查询", notes = "可以通过这个接口查询配发单")
    @GetMapping(value = "/archives/allot/detail1/{id}")
    public ResponseEntity selectAllotBillDetail2(@PathVariable("id") int id) {
        //获取所有装备id map
        Map<Integer,DeviceLibrary> deviceLibraryMap = deviceLibraryService.getAllDeviceMap();
        //返回的数组
        List<Object> list = new ArrayList<>();
        Integer billId = taskService.get(id).getBillId();
        //set账单用户名称并添加
        AllotBill allotBillEntity = allotBillService.getOne(billId);
        allotBillEntity.setSenderUserA(userService.getOne(allotBillEntity.getSendUseraId()).getName());
        allotBillEntity.setSenderUserB(allotBillEntity.getAgent());
        if (allotBillEntity.getReceiveUseraId() != null) {
            allotBillEntity.setReceiveUserA(userService.getOne(allotBillEntity.getReceiveUseraId()).getName());
        }
        if (allotBillEntity.getReceiveUserbId() != null) {
            allotBillEntity.setReceiveUserB(userService.getOne(allotBillEntity.getReceiveUserbId()).getName());
        }
        //转换文件
        allotBillEntity.setSendFileList(FilesUtil.stringFileToList(allotBillEntity.getSendFiles()));
        allotBillEntity.setReceiveFileList(FilesUtil.stringFileToList(allotBillEntity.getReceiveFiles()));
        allotBillEntity.setReplyFileList(FilesUtil.stringFileToList(allotBillEntity.getReplyFiles()));
        allotBillEntity.setApplyFileList(FilesUtil.stringFileToList(allotBillEntity.getApplyFiles()));
        //转换单据
        if (allotBillEntity.getScriptJson()!=null){
            allotBillEntity.setScripts(JacksonUtil.readValue(allotBillEntity.getScriptJson(),new TypeReference<List<ScriptSaveVo>>() {}));
        }
        list.add(allotBillEntity);
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        //如果接收装备详情不为空，分隔装备id并添加
        if (allotBillEntity.getAllotCheckDetail() != null) {
            for (Integer deviceId : StringSplitUtil.split(allotBillEntity.getAllotCheckDetail())) {
                libraryEntities.add(deviceLibraryMap.get(deviceId));
            }
        }
        list.add(libraryEntities);
        return ResponseEntity.ok(list);
    }

    @ApiOperation(value = "查询退回单详情页,通过taskId查询", notes = "可以通过这个接口查询退回单")
    @GetMapping(value = "/archives/back/detail1/{id}")
    public ResponseEntity selectBackBillDetail2(@PathVariable("id") int id) {
        //获取所有装备id map
        Map<Integer,DeviceLibrary> deviceLibraryMap = deviceLibraryService.getAllDeviceMap();
        //返回的数组
        List<Object> list = new ArrayList<>();
        //set账单用户名称并添
        Integer billId = taskService.get(id).getBillId();
        AllotBackBill allotBillEntity = allotBackBillService.getOne(billId);
        allotBillEntity.setSenderUserA(userService.getOne(allotBillEntity.getSendUseraId()).getName());
        allotBillEntity.setSenderUserB(allotBillEntity.getAgent());
        if (allotBillEntity.getReceiveUseraId() != null) {
            allotBillEntity.setReceiveUserA(userService.getOne(allotBillEntity.getReceiveUseraId()).getName());
        }
        if (allotBillEntity.getReceiveUserbId() !=null){
            allotBillEntity.setReceiveUserB(userService.getOne(allotBillEntity.getReceiveUserbId()).getName());
        }
        //转换文件
        allotBillEntity.setSendFileList(FilesUtil.stringFileToList(allotBillEntity.getSendFiles()));
        allotBillEntity.setReceiveFileList(FilesUtil.stringFileToList(allotBillEntity.getReceiveFiles()));
        allotBillEntity.setReplyFileList(FilesUtil.stringFileToList(allotBillEntity.getReplyFiles()));
        allotBillEntity.setApplyFileList(FilesUtil.stringFileToList(allotBillEntity.getApplyFiles()));
        //转换单据
        if (allotBillEntity.getScriptJson()!=null){
            allotBillEntity.setScripts(JacksonUtil.readValue(allotBillEntity.getScriptJson(),new TypeReference<List<ScriptSaveVo>>() {}));
        }
        list.add(allotBillEntity);
        List<DeviceLibrary> libraryEntities = new ArrayList<>();
        //如果接收装备详情不为空，分隔装备id并添加
        if (allotBillEntity.getBackCheckDetail() != null) {
            for (Integer deviceId : StringSplitUtil.split(allotBillEntity.getBackCheckDetail())) {
                libraryEntities.add(deviceLibraryMap.get(deviceId));
            }
        }
        list.add(libraryEntities);
        return ResponseEntity.ok(list);
    }

}
