package com.tykj.dev.device.allot.subject.domin;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for allot_bill
 * 配发账单
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update allot_bill set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("配发账单")
public class AllotBill {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 配发标题
     */
    @ApiModelProperty(value = "配发标题")
    private String title;
    /**
     * 申请文号
     */
    @ApiModelProperty(value = "申请文号")
    private String applyNumber;
    /**
     * 批复文号
     */
    @ApiModelProperty(value = "批复文号")
    private String replayNumber;
    /**
     * 配发单位
     */
    @ApiModelProperty(value = "配发单位")
    private String sendUnit;

    @ApiModelProperty(value = "发送单位Id")
    private Integer sendUnitId;
    /**
     * 收件单位
     */
    @ApiModelProperty(value = "收件单位")
    private String receiveUnit;

    @ApiModelProperty(value = "接受单位id")
    private Integer receiveUnitId;
    /**
     * 配发时间
     */
    @ApiModelProperty(value = "配发时间")
    private Date sendTime;
    /**
     * 接收时间
     */
    @ApiModelProperty(value = "接收时间")
    private Date receiveTime;
    /**
     * 发件签发人
     */
    @ApiModelProperty(value = "发件签发人")
    private String agent;
    /**
     * 配发类型
     */
    @ApiModelProperty(value = "配发类型",notes = "1 是纵向，")
    private Integer allotType;
    /**
     * 签发人和发件经办人(A岗位)
     */
    @ApiModelProperty(value = "发件经办人(A岗位)")
    private Integer sendUseraId;

    @ApiModelProperty(value = "发件经办人(A岗位)的电子签名")
    @Column(name = "send_usera_id_signature",columnDefinition = "TEXT")
    private String sendUseraIdSignature;
    /**
     * 发件方审核人id(B岗位)
     */
    @ApiModelProperty(value = "发件方审核人id(B岗位)")
    private Integer sendUserbId;

    @Column(name = "send_userb_id_signature",columnDefinition = "TEXT")
    @ApiModelProperty(value = "发件方审核人id(B岗位)的电子签名")
    private String sendUserbIdSignature;
    /**
     * 收件经办人id(A岗位)
     */
    @ApiModelProperty(value = "收件经办人id(A岗位)")
    private Integer receiveUseraId;

    @ApiModelProperty(value = "收件经办人id(A岗位)的电子签名")
    @Column(name = "receive_usera_id_signature",columnDefinition = "TEXT")
    private String receiveUseraIdSignature;
    /**
     * 收件方审核人id(B岗位)
     */
    @ApiModelProperty(value = "收件方审核人id(B岗位)")
    private Integer receiveUserbId;

    @ApiModelProperty(value = "收件方审核人id(B岗位)的电子签名")
    @Column(name = "receive_userb_id_signature",columnDefinition = "TEXT")
    private String receiveUserbIdSignature;
    /**
     * 出库附件文件名
     */
    @ApiModelProperty(value = "出库附件文件名")
    @Column(name = "file_name",columnDefinition = "TEXT")
    private String fileName;
    /**
     * 出库附件文件地址URL
     */
    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "出库附件文件地址URL")
    private String fileUrl;
    /**
     * 入库附件文件名
     */
    @ApiModelProperty(value = "入库附件文件名")
    @Column(name = "receive_file_name",columnDefinition = "TEXT")
    private String receiveFileName;
    /**
     * 入库附件文件地址URL
     */
    @Column(name = "receive_file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "入库附件文件地址URL")
    private String receiveFileUrl;
    /**
     * 账单文件名
     */
    @ApiModelProperty(value = "账单文件名")
    private String billFileName;
    /**
     * 账单文件地址URL
     */
    @Column(name = "bill_file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "账单文件地址URL")
    private String billFileUrl;
    /**
     * 配发状态(0:配发待审核，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成)
     */
    @ApiModelProperty(value = "配发状态(0:草稿，1:配发审核失败，2:配发中，3:配发接收待审核，4:配发接收审核失败，5:配发完成)")
    private Integer allotStatus;
    /**
     * 创建用户id
     */
    @CreatedBy
    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy
    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 配发装备数量
     */
    @ApiModelProperty(value = "配发装备数量")
    private Integer allotCount;
    /**
     * 已配发出库装备数量
     */
    @ApiModelProperty(value = "已配发出库装备数量")
    private Integer allotedCount;
    /**
     * 已接收装备数量
     */
    @ApiModelProperty(value = "已接收装备数量")
    private Integer receiveCount;
    /**
     * 配发出库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @Column(name = "allot_check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "配发出库检查详情(装备主键id+核对结果(0缺失1无误2不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String allotCheckDetail;
    /**
     * 配发出库检查结果
     */
    @ApiModelProperty(value = "配发出库检查结果")
    @Column(name = "allot_check_result",columnDefinition = "TEXT")
    private String allotCheckResult;
    /**
     * 配发接收方检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @Column(name = "receive_check_detail",columnDefinition = "TEXT")
    @ApiModelProperty(value = "配发接收方检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如10x21x32,意为主键id为1的装备缺失,为2的无误,为3的不匹配")
    private String receiveCheckDetail;
    /**
     * 接收方检查结果
     */
    @ApiModelProperty(value = "接收方检查结果")
    @Column(name = "receive_check_result",columnDefinition = "TEXT")
    private String receiveCheckResult;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "发件经办人")
    @Transient
    private String senderUserA;

    @ApiModelProperty(value = "收件经办人")
    @Transient
    private String receiveUserA;

    @ApiModelProperty(value = "收件方审核人")
    @Transient
    private String receiveUserB;

    @ApiModelProperty(value = "发件方审核人")
    @Transient
    private String senderUserB;

    @ApiModelProperty(value = "审核时间")
    @Transient
    private Date confirmTime;

    @ApiModelProperty(value = "配发单号")
    private String num;

    @ApiModelProperty(value = "发件单位签章id")
    private String leftSignatureId;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    @ApiModelProperty(value = "装备集合")
    @Transient
    private List<DeviceLibrary> deviceLibraries;

    @ApiModelProperty(value = "批复文号文件")
    @Column(name = "reply_files",columnDefinition = "TEXT")
    private String replyFiles;

    @ApiModelProperty(value = "申请文号文件")
    @Column(name = "apply_files",columnDefinition = "TEXT")
    private String applyFiles;

    @ApiModelProperty(value = "发件方回执单")
    @Column(name = "send_files",columnDefinition = "TEXT")
    private String sendFiles;

    @ApiModelProperty(value = "收件方签收单")
    @Column(name = "receive_files",columnDefinition = "TEXT")
    private String receiveFiles;

    @ApiModelProperty(value = "单据集合json")
    @Column(name = "script_json",columnDefinition = "TEXT")
    private String scriptJson;

    @ApiModelProperty(value = "单据集合")
    @Transient
    private List<ScriptSaveVo> scripts = new ArrayList<>();

    @ApiModelProperty(value = "批复文号文件集合")
    @Transient
    private List<FileRet> replyFileList = new ArrayList<>();

    @ApiModelProperty(value = "申请文号文件集合")
    @Transient
    private List<FileRet> applyFileList = new ArrayList<>();

    @ApiModelProperty(value = "发件方回执单集合")
    @Transient
    private List<FileRet> sendFileList = new ArrayList<>();

    @ApiModelProperty(value = "收件方签收单集合")
    @Transient
    private List<FileRet> receiveFileList = new ArrayList<>();

    @ApiModelProperty(value = "任务id")
    @Transient
    private Integer taskId;

}
