package com.tykj.dev.device.allot.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配发接收类")
public class AllotReceiveVo {

    @ApiModelProperty(value = "接收单位B岗")
    private Integer sendUserbId;

    @ApiModelProperty(value = "发件经办人(A岗位)的电子签名")
    private String sendUseraIdSignature;
    @ApiModelProperty(value = "发件方审核人id(B岗位)的电子签名")
    private String sendUserbIdSignature;

//    @NotNull(message = "receiveUserbId不能为空")
//    @Min(value = 1,message = "receiveUserbId不能小于1")
    @ApiModelProperty(value = "接收单位B岗")
    private Integer receiveUserbId;

    @ApiModelProperty(value = "接收单位A岗  经办人右下")
    private Integer receiveUseraId;

    @ApiModelProperty(value = "收件经办人id(A岗位)的电子签名")
    private String receiveUseraIdSignature;

    @ApiModelProperty(value = "收件方审核人id(B岗位)的电子签名")
    private String receiveUserbIdSignature;


    @NotNull(message = "taskId不能为空")
    @Min(value = 1,message = "taskId不能小于1")
    @ApiModelProperty(value = "任务Id")
    private Integer taskId;

//    @NotNull(message = "billFileName不能为空")
    @ApiModelProperty(value = "配发单附件名字")
    private String billFileName;

//    @NotNull(message = "billFileUrl不能为空")
    @ApiModelProperty(value = "配发单附件URL")
    private String billFileUrl;

//    @NotNull(message = "receiveFileName不能为空")
    @ApiModelProperty(value = "入库附件名字")
    private String receiveFileName;

//    @NotNull(message = "receiveFileUrl不能为空")
    @ApiModelProperty(value = "入库附件URL")
    private String receiveFileUrl;

    @NotNull(message = "receiveCount不能为空")
    @ApiModelProperty(value = "接收入库数量")
    private Integer receiveCount;

    @NotNull(message = "receiveCheckDetail不能为空")
    @ApiModelProperty(value = "接收入库检查详情")
    private String receiveCheckDetail;

    @NotNull(message = "receiveCheckResult不能为空")
    @ApiModelProperty(value = "接收入库检查结果")
    private String receiveCheckResult;

    @ApiModelProperty(value = "填写生产序列号map")
    private Map<Integer,String> map = new HashMap<>();

    @NotNull(message = "status不能为空")
    @ApiModelProperty(value = "是否二方都盖章了（0：否，1：是）")
    private Integer status = 0;

    @ApiModelProperty(value = "接收方配发单")
    private List<FileRet> receiveFileList;

    @ApiModelProperty(value = "收件单位签章id")
    private String rightSignatureId;
}
