package com.tykj.dev.device.apply.service;


import com.tykj.dev.device.apply.subject.domin.DeviceApplyBill;
import com.tykj.dev.device.apply.subject.vo.*;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface DeviceApplyBillService {

    DeviceApplyBill addEntity(DeviceApplyBill deviceApplyBillEntity);

    /**
     * @param deviceApplyBills 异步上链
     */
    void sendHash(List<DeviceApplyBill> deviceApplyBills);

    DeviceApplyBill update(DeviceApplyBill deviceApplyBillEntity);

    DeviceApplyBill getOne(Integer id);

    /**
     * @param scriptSaveVos 退役/报废/销毁装备单据详情
     * 更新装备对应申请任务的已完成数量
     */
    void updateCompleteNum(Integer applyType , List<ScriptSaveVo> scriptSaveVos);

    List<StringBuffer> checkNumAndSeqNumber(List<ApplyTaskDeviceCheckVo> applyTaskDeviceCheckVos);

    /**
     * 其他申请做检验
     * @param otherApplyTaskDeviceCheckVos
     * @return
     */
    List<StringBuffer> checkNumAndSeqNumberForOtherApply(List<OtherApplyTaskDeviceCheckVo> otherApplyTaskDeviceCheckVos);

    /**
     * 申请任务入库   当修改试用装备序列时，移除序列号区间中所在的序列号
     */
    List<String> removeFromSeqList(RemoveFromSeqListVo removeFromSeqListVo);


    ApplyRemoveSeqVo removeSameSeq(RemoveSameSeqVo removeSameSeqVo);

}
