package com.tykj.dev.device.apply.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("申请详情类")
@AllArgsConstructor
@NoArgsConstructor
public class ApplyBillDetailVo {

//    @NotNull(message = "packingId不能为空")
//    @Min(value = 1,message = "packingId不能小于1")
    @ApiModelProperty(value = "列装id")
    private Integer packingId;

//    @NotNull(message = "storageCount不能为空")
//    @Min(value = 1,message = "storageCount不能小于1")
    @ApiModelProperty(value = "申请数量")
    private Integer storageCount;

    @ApiModelProperty(value = "可入库数量")
    private Integer waitNum;

    @ApiModelProperty(value = "已入库数量")
    private Integer completeCount = 0;

    @ApiModelProperty(value = "批复数量")
    private Integer replyNum;

    @ApiModelProperty(value = "已选中申请数量")
    private Integer selectApplyNum;

    @ApiModelProperty(value = "装备id")
    private List<Integer> deviceIds;


    @ApiModelProperty(value = "序列号区间", example = "1")
    private String seqInterval;

    private List<ApplyBillDetailVo> childs;

    public void setChildNull() {
        childs=null;
    }

}
