package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 装备可见范围枚举
 */

@AllArgsConstructor
public enum DeviceSecretLevel {
    /**
     * 省一级
     */
    SECRETLEVEL_1(1, "绝密"),
    /**
     * 县一级
     */
    SECRETLEVEL_2(2, "秘密"),
    /**
     * 市一级
     */
    SECRETLEVEL_3(3, "机密"),
    /**
     * 县一级
     */
    SECRETLEVEL_4(4, "无");

    public Integer id;

    public String name;

    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("密级");
        systemConfig.setEnglishName("secretLevel");
        return systemConfig;
    }
}
