package com.tykj.dev.config.base;

import com.tykj.dev.config.domin.SystemConfig;
import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 入库类型枚举
 */

@AllArgsConstructor
public enum StorageType {
    /**
     * 横向
     */
    HORIZONTAL(1, "横向"),
    /**
     * 纵向
     */
    VERTICAL(2, "纵向"),
    /**
     * 委托
     */
    ENTRUST(3, "委托"),
    /**
     * 代管
     */
    ESCROW(4, "代管"),
    /**
     * 其他
     */
    OTHER(5, "其他");

    public Integer id;

    public String name;


    public SystemConfig toDo(){
        SystemConfig systemConfig = new SystemConfig();
        systemConfig.setValue(id);
        systemConfig.setLabel(name);
        systemConfig.setChineseName("入库类型");
        systemConfig.setEnglishName("storageType");
        return systemConfig;
    }
}
