package com.tykj.dev.config.service.impl;

import com.tykj.dev.config.cache.ConfigCache;
import com.tykj.dev.config.domin.SystemConfig;
import com.tykj.dev.config.repository.SystemConfigDao;
import com.tykj.dev.config.service.SystemConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.Map;

@Service
public class SystemConfigServiceImpl implements SystemConfigService {

    @Autowired
    SystemConfigDao systemConfigDao;

    @Autowired
    ConfigCache configCache;

    @Override
    public SystemConfig add(SystemConfig systemConfig) {
        SystemConfig systemConfig1 = systemConfigDao.save(systemConfig);
        configCache.refresh(systemConfigDao.findAll());
        return systemConfig1;
    }

    @Override
    public SystemConfig update(SystemConfig systemConfig) {
        SystemConfig systemConfig1 = systemConfigDao.save(systemConfig);
        configCache = new ConfigCache(systemConfigDao.findAll());
        return systemConfig1;
    }

    @Override
    public void delete(Integer id) {
        systemConfigDao.deleteById(id);
    }

    @Override
    public Integer getMaxValue(String englishName) {
        List<SystemConfig> systemConfigs = systemConfigDao.findAllByEnglishName(englishName);
        if (systemConfigs.size()>0) {
            return systemConfigs.stream().max(Comparator.comparing(SystemConfig::getValue)).get().getValue();
        }
        else {
            return null;
        }
    }

    @Override
    public SystemConfig getOne(Integer id) {
        return systemConfigDao.findById(id).get();
    }

    @Override
    public Map<Integer, String> getStorageLocationMap() {
        return configCache.getStorageLocationMap();
    }

}
