package com.tykj.dev.device.confirmcheck.common;

import com.tykj.dev.config.Log;
import com.tykj.dev.misc.base.StatusEnum;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

import static com.tykj.dev.misc.base.StatusEnum.*;

/**
 * CheckChart. 里面用于存放核查模块要用到的一些对照表Map
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/8/19 at 3:14 下午
 */
@Data
@Slf4j
public class CheckChart {


    /**
     * key = 任务状态编号 , value = 核查情况 , 用于市区自核查页面
     */
    public static Map<Integer, String> taskStatus2Situation = new HashMap<>();

    static {
        taskStatus2Situation.put(CHECK_DETAIL_CITY_0.id, "无");
        taskStatus2Situation.put(CHECK_DETAIL_CITY_1.id, "进行中");
        taskStatus2Situation.put(CHECK_DETAIL_REGION_0.id, "无");
        taskStatus2Situation.put(CHECK_DETAIL_REGION_1.id, "进行中");
        taskStatus2Situation.put(CHECK_DETAIL_REGION_2.id, "等待市审核");
        taskStatus2Situation.put(END.id, "完成");
        log.info("[核查模块] 初始化taskStatus2Situation 完毕 , size = {}",CheckChart.taskStatus2Situation.size());
    }


}
