//package com.tykj.dev.device.confirmcheck.controller;
//
//import com.google.common.collect.ImmutableMap;
//import com.tykj.dev.config.swagger.AutoDocument;
//import com.tykj.dev.device.confirmcheck.common.CheckType;
//import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckDetail;
//import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckStat;
//import com.tykj.dev.device.confirmcheck.entity.vo.*;
//import com.tykj.dev.device.confirmcheck.repository.DeviceCheckBillDao;
//import com.tykj.dev.device.confirmcheck.repository.DeviceCheckDetailDao;
//import com.tykj.dev.device.confirmcheck.repository.DeviceCheckLinkDao;
//import com.tykj.dev.device.confirmcheck.repository.DeviceCheckStatDao;
//import com.tykj.dev.device.confirmcheck.service.CheckUnitService;
//import com.tykj.dev.device.confirmcheck.service.ConfirmCheckService;
//import com.tykj.dev.device.confirmcheck.utils.ObjTransUtil;
//import com.tykj.dev.device.library.repository.DeviceLibraryDao;
//import com.tykj.dev.device.library.service.DeviceLibraryCacheService;
//import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
//import com.tykj.dev.device.selfcheck.controller.SelfCheckController;
//import com.tykj.dev.device.task.repository.TaskDao;
//import com.tykj.dev.device.task.service.TaskLogService;
//import com.tykj.dev.device.task.service.TaskService;
//import com.tykj.dev.device.task.subject.bto.TaskBto;
//import com.tykj.dev.device.task.subject.domin.Task;
//import com.tykj.dev.device.user.base.enums.AuExample;
//import com.tykj.dev.device.user.cache.AreaCache;
//import com.tykj.dev.device.user.cache.UnitsCache;
//import com.tykj.dev.device.user.read.service.MessageService;
//import com.tykj.dev.device.user.subject.dao.AreaDao;
//import com.tykj.dev.device.user.subject.dao.UnitsDao;
//import com.tykj.dev.device.user.subject.entity.Units;
//import com.tykj.dev.device.user.subject.entity.User;
//import com.tykj.dev.device.user.subject.entity.bto.AreaUnit;
//import com.tykj.dev.device.user.subject.service.AuService;
//import com.tykj.dev.device.user.subject.service.UnitsService;
//import com.tykj.dev.device.user.subject.service.UserService;
//import com.tykj.dev.device.user.util.AuthenticationUtils;
//import com.tykj.dev.misc.utils.JacksonUtil;
//import com.tykj.dev.socket.MyWebSocket;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.http.ResponseEntity;
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestBody;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//
//import java.time.LocalDateTime;
//import java.util.*;
//import java.util.function.Function;
//
//import static com.tykj.dev.misc.base.BusinessEnum.CONFIRM_CHECK_DETAIL;
//import static com.tykj.dev.misc.base.BusinessEnum.CONFIRM_CHECK_STAT;
//import static com.tykj.dev.misc.base.StatusEnum.*;
//import static com.tykj.dev.misc.base.StatusEnum.CHECK_DETAIL_REGION_0;
//import static java.util.stream.Collectors.*;
//
///**
// * @author tykj
// */
//@RestController
//@RequestMapping(value = "/check")
//@AutoDocument
//@Slf4j
//@Api(tags = "核查(核查)模块", description = "核查模块", position = 1)
//public class CheckController {
//
//
//    final String CHECK_RESULT_WAIT = "等待省查阅";
//    final String CHECK_RESULT_DONE = "已查阅";
//    Map<Integer, String> desMap = new HashMap<>();
//    Map<Integer, String> desBillMap = new HashMap<>();
//    private int specialDetailId = 0;
//    private List<String> specialUnits = new ArrayList<>();
//
//
//    @Autowired
//    private UnitsCache unitsCache;
//    @Autowired
//    private DeviceCheckLinkDao linkRepo;
//    @Autowired
//    private DeviceCheckStatDao statRepo;
//    @Autowired
//    private DeviceCheckBillDao billRepo;
//    @Autowired
//    private AreaDao areaRepo;
//    @Autowired
//    private UnitsDao unitsRepo;
//    @Autowired
//    private DeviceLibraryDao deviceRepo;
//    @Autowired
//    private DeviceCheckDetailDao detailRepo;
//    @Autowired
//    private DeviceLibraryCacheService dcService;
//    @Autowired
//    private ObjTransUtil transUtil;
//    @Autowired
//    private TaskDao taskRepo;
//    @Autowired
//    private TaskService taskService;
//    @Autowired
//    private AuthenticationUtils authenticationUtils;
//    @Autowired
//    private AreaCache areaCache;
//    @Autowired
//    private AuService auService;
//    @Autowired
//    private ConfirmCheckService ccService;
//    @Autowired
//    private UserService userService;
//    @Autowired
//    private MyWebSocket myWebSocket;
//    @Autowired
//    private SelfCheckController selfCheckController;
//    @Autowired
//    private MessageService messageService;
//    @Autowired
//    private TaskLogService taskLogService;
//    @Autowired
//    private UnitsService unitsService;
//    @Autowired
//    private CheckUnitService checkUnitService;
//
//
//
//    @ApiOperation(value = "发起核查", notes = "对指定单位发起核查任务")
//    @PostMapping("/startCheck/bak")
//    public ResponseEntity startCheck(@RequestBody CheckCheckVo ccVO) {
//
//        // 代管单位id
//        List<Integer> esIds = checkUnitService.findAllEscrow().stream().map(Units::getUnitId).collect(toList());
//        esIds.retainAll(ccVO.getUnitRange());
//
//        // 构建省的统计账单
//        Integer startUnitId = ccVO.getUnitId();
//        Units startUnit = unitsRepo.findById(startUnitId).get();
//        List<Units> checkedUnits = unitsRepo.findAllById(ccVO.getUnitRange());
//        // 1.发起自己的自查 (市,tpye=2,省 level = 0,1,2)
//        // 2.发起自己的检查(只是市级别的 level=2)
//        List<String> checkedUnitNames = checkedUnits.stream().map(Units::getName).collect(toList());
//
//        log.info("[核查模块]发起核查，发起单位为{},被查单位为{}", startUnit.getName(), checkedUnitNames);
//
//        // 构建省的统计账单,所有的checkedUnits都要被包含到统计中去
//        DeviceCheckStat provinceCheckStat = initStatData(ccVO.getTitle(), ccVO.getRemark(), 0, 0, startUnit.getName(), checkedUnits, ccVO.getEndTime().atStartOfDay());
//        provinceCheckStat.setCheckType(CheckType.CT_CHECK);
//        Integer statId = statRepo.save(provinceCheckStat).getId();
//        List<CheckDeviceStatVo> deviceStatVos = Arrays.stream(
//                Objects.requireNonNull(JacksonUtil.readValue(provinceCheckStat.getStatInfo(), CheckDeviceStatVo[].class)))
//                .collect(toList());
//
//        // 构建省的统计任务
//        TaskBto provStatTask = new Task(CHECK_STAT_1.id, getUnitDateString(startUnit, ccVO.getTitle()), 0, ".0.", CONFIRM_CHECK_STAT.id, statId, startUnitId)
//                .parse2Bto();
//        provStatTask.getInvolveUserIdList().add(authenticationUtils.getAuthentication().getCurrentUserInfo().getUserId());
//        provStatTask.getInvolveUserIdList().add(0);
//        provStatTask.setCurrentPoint(1);
//        provStatTask.setCustomInfo("check");
//        provStatTask = taskService.start(provStatTask);
//
//        desMap.put(provStatTask.getId(), ccVO.getRemark());
//
//
//        //构建市的检查任务(level=2)
//        List<Units> examCheckUnits = checkedUnits.stream()
//                .filter(units -> Arrays.asList(2).contains(units.getLevel()))
//                .collect(toList());
//
//        Map<Integer, Integer> cityExamIdMap = new HashMap<>();
//
//        // 获取哪些市建立了统计任务
//        List<Integer> citys = new ArrayList<>();
//
//        for (Units unit : examCheckUnits) {
//
//            //构建市的统计账单
//            String cityTitle = unit.getName() + "检查统计";
//            DeviceCheckStat cityCheckStat = initStatData(cityTitle, ccVO.getRemark(),
//                    0, 0, unit.getName(), Collections.emptyList(), ccVO.getEndTime().atStartOfDay());
//            cityCheckStat.setCheckType(CheckType.CT_EXAM);
//            Integer cityStatId = statRepo.save(cityCheckStat).getId();
//            log.info("[核查模块] {} 检查统计账单构建完毕,id 为 {}", unit.getName(), cityStatId);
//
//            // 构建市的统计任务
//            TaskBto cityStatTask = new TaskBto(CHECK_EXAM_STAT_0.id, getUnitDateString(unit, ccVO.getTitle()), provStatTask.getId(), addNode(provStatTask.getNodeIdDetail(), provStatTask.getId()), CONFIRM_CHECK_STAT.id, cityStatId, unit.getUnitId(), 0);
//            cityStatTask.getInvolveUserIdList().add(0);
//            cityStatTask.setCurrentPoint(1);
//            cityStatTask.setCustomInfo("exam");
//            cityStatTask = taskService.start(cityStatTask);
//
//            //将市的检查id记录下，以便设置市的自查任务的父级节点
//            cityExamIdMap.put(unit.getUnitId(), cityStatTask.getId());
//
//            // 自动创建市里的任务
//            List<Units> inCitys = unitsCache.findByIdSubordinateAndOneself(unit.getUnitId());
//            CheckExamVo checkExamVo = new CheckExamVo();
//            checkExamVo.setDetail(Collections.singletonList(
//                    CheckExamDetailVo.builder().
//                            unitIds(
//                                    checkUnitService.findExistDevice(
//                                            inCitys.stream()
//                                                    .filter(units -> units.getUnitId() != unit.getUnitId())
//                                                    .map(Units::getUnitId)
//                                                    .collect(toList())
//                                    )
//                            )
//                            .remark(ccVO.getRemark())
//                            .build())
//            );
//            checkExamVo.setTitle(ccVO.getTitle());
//            checkExamVo.setUnitId(unit.getUnitId());
//            checkExamVo.setExamStatId(cityStatId);
//            checkExamVo.setEndTime(ccVO.getEndTime());
////            startExam(checkExamVo);
//        }
//
//        // 构建自核查任务(levl = 0,1) tpye = 2
//        List<Units> selfCheckUnits = checkedUnits.stream()
//                .filter(units -> Arrays.asList(0, 1).contains(units.getLevel()) || units.getType() == 2)
//                .collect(toList());
//
//        // 获取所有在库装备 lifeStatus ==2 or 14
//        Map<String, List<DeviceLibrary>> devInLib = dcService.getAllDeviceLibraryList().stream()
////                .filter(device -> device.getOwnUnit().equals(device.getLocationUnit()))
//                .filter(d -> d.getLifeStatus() == 2 || d.getLifeStatus() == 14)
//                .collect(groupingBy(DeviceLibrary::getOwnUnit));
//
//        // 获取所有非在库装备 ls != 2 and != 14
//        Map<String, List<DeviceLibrary>> devNotInLib = dcService.getAllDeviceLibraryList().stream()
////                .filter(device -> !device.getOwnUnit().equals(device.getLocationUnit()))
//                .filter(d -> d.getLifeStatus() != 2 && d.getLifeStatus() != 14)
//                .collect(groupingBy(DeviceLibrary::getOwnUnit));
//
//
//        User loginUser = authenticationUtils.getAuthentication().getCurrentUserInfo();
//
//        for (Units unit : selfCheckUnits) {
//            //核查组成员名称用当前登录用户
//            String names = "默认检查组";
//
//            // 如果是市level=2 的话,father Id为市的检查id
//            Integer fatherId = 0;
//            Integer initStatusId = 0;
//
//            // level = 1 或者2 市省级 否则 就是区级 ，市省级的自查初始状态160，区级的自查初始状态140
//            // type = 2 160 ，tpye = 1 && level = 1 || level = 2 160
//            boolean directProv = unit.getType() == 2;
//            boolean normalProv = unit.getType() == 1 && (unit.getLevel() == 1 || unit.getLevel() == 2);
//
//            if (directProv || normalProv) {
//                fatherId = cityExamIdMap.get(unit.getUnitId());
//                initStatusId = CHECK_DETAIL_CITY_0.id;
//                if (fatherId == null) {
//                    fatherId = provStatTask.getId();
//                }
//            } else {
//                fatherId = provStatTask.getId();
//                initStatusId = CHECK_DETAIL_REGION_0.id;
//            }
//
//            // 3-1  构建被查单位的 自核查账单
//            DeviceCheckDetail unitDetailDoc = DeviceCheckDetail
//                    .EmptyWithChecker(names + "|" + "默认备注", ccVO.getRemark(),
//                            0, 0, 0, 0, unit.getName(),
//                            unitsRepo.findByName(unit.getName()).getUnitId(),
//                            devInLib.getOrDefault(unit.getName(), new ArrayList<>()),
//                            devNotInLib.getOrDefault(unit.getName(), new ArrayList<>()));
//            unitDetailDoc.setVar2(String.valueOf(initStatusId));
//            DeviceCheckDetail detail = detailRepo.save(unitDetailDoc);
//            // 将id放入统计中去 model ->  areaName -> detailId
//            String areaName = auService.findOne(AuExample.UnitId, unit.getUnitId()).getName();
//            for (CheckDeviceStatVo statVo : deviceStatVos) {
//                for (CheckAreaStatVo asv : statVo.getAreaStatList()) {
//                    if (asv.getAreaName().equals(areaName)) {
//                        asv.setAreaStatId(statId);
//                        asv.setAreaDetailId(detail.getId());
//                    }
//                }
//            }
//
//            // 3-2  构建被查单位的 自查任务 (根据被查单位的级别来区分是县级状态是市级状态) 这里的父级任务应该是省统计
//
//            //处理ownUnit的代码 - 如果省直属有账号发给省直属的，没有账号就发给省做 用于处理没有账号的单位的可见性
//            Integer ownUnitId = 0;
//            boolean notHasAccount = unit.getEscrow() == 1;
//            if (notHasAccount) {
//                ownUnitId = 1;
//            } else {
//                ownUnitId = unit.getUnitId();
//            }
//
//            TaskBto checkedTask = new TaskBto(initStatusId, getUnitDateString(unit, ccVO.getTitle()), fatherId, addNode(provStatTask.getNodeIdDetail(), provStatTask.getId()), CONFIRM_CHECK_DETAIL.id, detail.getId(), ownUnitId, 0);
//            checkedTask.setCustomInfo("manual");
//            taskService.start(checkedTask);
//        }
//
//
//        return ResponseEntity.ok(ImmutableMap.of("msg", "发起核查成功"));
//    }
//
//
//    /**
//     * @param initUnitNames 初始化指定单位的数据
//     * @return
//     */
//    private DeviceCheckStat initStatData(List<String> initUnitNames, String title, String remark, Integer checkAId, Integer checkBId, String startUnitName, List<Units> unitsList, LocalDateTime endTime) {
//        return new DeviceCheckStat(
//                CheckType.CT_EXAM,
//                title,
//                startUnitName + "待核查装备统计单",
//                "[]",
//                checkAId,
//                checkBId,
//                remark,
//                endTime);
//    }
//
//    /**
//     * 构建初始化核查统计数据
//     * 依据不同地区装备的在库情况构造出舒适化的统计数据出来
//     *
//     * @param title         标题
//     * @param remark        备注
//     * @param checkAId      核查组成员A id
//     * @param checkBId      核查组成员B id
//     * @param startUnitName 发起核查的单位名
//     * @param unitsList     被核查单位列表
//     * @return 一份初始化好统计数据(没有向上合并 ， 只做了同级地区数据合并)的核查统计单
//     */
//    private DeviceCheckStat initStatData(String title, String remark, Integer checkAId, Integer checkBId, String startUnitName, List<Units> unitsList, LocalDateTime endTime) {
//        //获得要被统计的单位名列表
//        List<String> unitNameList = unitsList.stream()
//                .map(Units::getName)
//                .collect(toList());
//
//        List<AreaUnit> auList = unitsList.stream()
//                .map(units -> auService.findOne(AuExample.UnitId, units.getUnitId()))
//                .collect(toList());
//
//        Collection<CheckDeviceStatVo> statVos;
//        List<CheckDeviceStatVo> cds = dcService.getAllDeviceLibraryList()
//                .stream()
//                .filter(dev -> unitNameList.contains(dev.getOwnUnit()))
////                .filter(d->d.getLifeStatus() != 2 & d.getLifeStatus() != 14)
//                .map(transUtil::device2InitStatVo)
//                .collect(toList());
//
//        statVos = cds.stream()
//                .collect(toMap(d -> d.getDeviceModel() + d.getDeviceName(), Function.identity(), CheckDeviceStatVo::reduce))
//                .values();
//
//        //缺省地区数据补充 下面这段代码意义不明 - - 先注释掉 ，后面想起来了再决定是用还是删除
////        for (CheckDeviceStatVo statVo : statVos) {
////            if (statVo.getAreaStatList().size() < unitNameList.size()) {
////                List<String> existsAreaNames = statVo.getAreaStatList().stream()
////                        .map(CheckAreaStatVo::getAreaName)
////                        .collect(toList());
////                List<CheckAreaStatVo> supplementVos = auList.stream()
////                        .filter(au -> !existsAreaNames.contains(au.getName()))
////                        .map(au -> new CheckAreaStatVo(au.getName(), 0, 0, 0, 0, 0, 0))
////                        .collect(toList());
////                statVo.getAreaStatList().addAll(supplementVos);
////            }
////        }
//
//        return new DeviceCheckStat(
//                CheckType.CT_EXAM,
//                title,
//                startUnitName + "待核查装备统计单",
//                JacksonUtil.toJSon(new ArrayList<>(statVos)),
//                checkAId,
//                checkBId,
//                remark,
//                endTime);
//    }
//    private String getUnitDateString(Units units, String title) {
//        return "[" + units.getUnitDesc() + "]" + title;
//
//    }
//
//
//    private String addNode(String originalNode, Integer fatherId) {
//        return originalNode + fatherId + ".";
//    }
//
//}
