package com.tykj.dev.device.confirmcheck.controller;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.confirmcheck.common.CheckType;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckDetail;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckStat;
import com.tykj.dev.device.confirmcheck.entity.vo.*;
import com.tykj.dev.device.confirmcheck.repository.DeviceCheckBillDao;
import com.tykj.dev.device.confirmcheck.repository.DeviceCheckDetailDao;
import com.tykj.dev.device.confirmcheck.repository.DeviceCheckLinkDao;
import com.tykj.dev.device.confirmcheck.repository.DeviceCheckStatDao;
import com.tykj.dev.device.confirmcheck.service.CheckUnitService;
import com.tykj.dev.device.confirmcheck.service.ConfirmCheckService;
import com.tykj.dev.device.confirmcheck.service.EscrowService;
import com.tykj.dev.device.confirmcheck.utils.ObjTransUtil;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.library.service.DeviceLibraryCacheService;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.selfcheck.controller.SelfCheckController;
import com.tykj.dev.device.task.repository.TaskDao;
import com.tykj.dev.device.task.service.TaskLogService;
import com.tykj.dev.device.task.service.TaskService;
import com.tykj.dev.device.task.subject.bto.TaskBto;
import com.tykj.dev.device.task.subject.domin.Task;
import com.tykj.dev.device.user.base.enums.AuExample;
import com.tykj.dev.device.user.cache.AreaCache;
import com.tykj.dev.device.user.cache.AreaExhibitionCache;
import com.tykj.dev.device.user.read.service.MessageService;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.Units;
import com.tykj.dev.device.user.subject.entity.bto.AreaUnit;
import com.tykj.dev.device.user.subject.service.AuService;
import com.tykj.dev.device.user.subject.service.UnitsService;
import com.tykj.dev.device.user.subject.service.UserService;
import com.tykj.dev.device.user.util.AuthenticationUtils;
import com.tykj.dev.misc.base.ResultObj;
import com.tykj.dev.misc.exception.ApiException;
import com.tykj.dev.misc.utils.JacksonUtil;
import com.tykj.dev.socket.MyWebSocket;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.*;
import java.util.function.Function;

import static com.tykj.dev.misc.base.BusinessEnum.CONFIRM_CHECK_DETAIL;
import static com.tykj.dev.misc.base.BusinessEnum.CONFIRM_CHECK_STAT;
import static com.tykj.dev.misc.base.StatusEnum.*;
import static com.tykj.dev.misc.base.StatusEnum.CHECK_DETAIL_CITY_0;
import static java.util.stream.Collectors.*;

/**
 * @author Ozoz.L cnljj1995@gmail.com
 * on 11/10/21
 */
@SuppressWarnings("Duplicates")
@RestController
@RequestMapping(value = "/check")
@AutoDocument
@Slf4j
@Api(tags = "核查模块(检查)", description = "检查模块", position = 2)
public class ExamController {

    @Autowired
    private EscrowService escrowService;
    @Autowired
    private UnitsDao unitsRepo;


    final String CHECK_RESULT_WAIT = "等待省查阅";
    final String CHECK_RESULT_DONE = "已查阅";
    Map<Integer, String> desMap = new HashMap<>();
    Map<Integer, String> desBillMap = new HashMap<>();
    private int specialDetailId = 0;
    private List<String> specialUnits = new ArrayList<>();

    @Autowired
    private CheckUnitService checkUnitService;
    @Autowired
    private DeviceCheckLinkDao linkRepo;
    @Autowired
    private DeviceCheckStatDao statRepo;
    @Autowired
    private DeviceCheckBillDao billRepo;
    @Autowired
    private AreaDao areaRepo;
    @Autowired
    private DeviceLibraryDao deviceRepo;
    @Autowired
    private DeviceCheckDetailDao detailRepo;
    @Autowired
    private DeviceLibraryCacheService dcService;
    @Autowired
    private ObjTransUtil transUtil;
    @Autowired
    private TaskDao taskRepo;
    @Autowired
    private TaskService taskService;
    @Autowired
    private AuthenticationUtils authenticationUtils;
    @Autowired
    private AreaCache areaCache;
    @Autowired
    private AuService auService;
    @Autowired
    private ConfirmCheckService ccService;
    @Autowired
    private UserService userService;
    @Autowired
    private MyWebSocket myWebSocket;
    @Autowired
    private SelfCheckController selfCheckController;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TaskLogService taskLogService;
    @Autowired
    private UnitsService unitsService;
    @Autowired
    AreaExhibitionCache areaExhibitionCache;


    @GetMapping("/check/confirm/escrow")
    @ApiOperation(value = "判断task是否为代管单位的详情任务")
    public ResponseEntity judgeEscrowUnit(@RequestParam Integer billId, @RequestParam Integer type) {

        Task task = taskRepo.findByBillIdAndBusinessType(billId, type).get();

        if (task.getTitle().contains("["+areaExhibitionCache.checkSpecial().get(2)+"]")) {
            return ResponseEntity.ok(ImmutableMap.of("msg", true));
        }

        if ("-1".equals(task.getExhibit()) && task.getBusinessType() == 8 && unitsService.isProvUnit(task.getOwnUnit())) {
            return ResponseEntity.ok(ImmutableMap.of("msg", true));
        }

        return ResponseEntity.ok(ImmutableMap.of("msg", false));

    }

    @GetMapping("/escrow/unit")
    @ApiOperation(value = "查询所有的代管单位，true_过滤无装备的单位，false_不过滤无装备的单位")
    public ResponseEntity findEscrowUnit(@RequestParam(defaultValue = "false") boolean filter) {
        return ResponseEntity.ok(new ResultObj<>(escrowService.findAllEscrowUnit(filter)));
    }

    @ApiOperation(value = "检查地区是否可以发起核查,并返回没有装备的单位id", notes = "检查地区是否可以发起核查")
    @PostMapping("/confirm/checkPossible")
    public ResponseEntity checkPossible(@RequestBody UnitIds unitIds, @RequestParam(defaultValue = "false") boolean isExam) {

        if (!isExam) {
            // 核查
            List<Units> rs = new ArrayList<>();
            rs.addAll(unitsRepo.findAllById(checkUnitService.findUnExistDevice(unitIds.getIds())));
            List<Integer> collect = unitsRepo.findAllById(unitIds.getIds()).stream().filter(o -> o.getLevel() == 2).map(Units::getUnitId).collect(toList());
            log.info("[check] 获取核查单位，{}", collect);

            if (!collect.isEmpty()) {
                for (Integer integer : collect) {
                    List<Units> bySubordinateAll = unitsService.findBySubordinateAll(integer);
                    log.info("[check] 查询市级核查单位:{}", bySubordinateAll);
                    List<Integer> unExistDevice = checkUnitService.findUnExistDevice(bySubordinateAll.stream().map(Units::getUnitId).collect(toList()));
                    log.info("[check] 市级无装备的单位:{}", unExistDevice);
                    rs.addAll(unitsRepo.findAllById(unExistDevice));
                }
            }
            return ResponseEntity.ok(rs.stream().distinct().collect(toList()));
        } else {
            // 检查
            List<Units> units = unitsRepo.findAllById(checkUnitService.findUnExistDevice(unitIds.getIds()));
            return ResponseEntity.ok(units);
        }
    }

    @GetMapping("/confirm/unit")
    @ApiOperation(value = "查询默认的可以被核查单位的清单(省本直,省直属,市局),同时过滤掉那些已经被代管的单位")
    public ResponseEntity findDefaultUnits(@RequestParam(defaultValue = "false") boolean isExam) {
        Integer unitId = authenticationUtils.getAuthentication().getCurrentUserInfo().getUnitsId();
        if (unitsService.isProvUnit(unitId)) {
            Map<Integer, List<Units>> checkUnit = checkUnitService.findCheckUnit(isExam);
            // 需要去除掉被托管的单位
            return ResponseEntity.ok(new ResultObj<>(checkUnit));
        } else {
            return ResponseEntity.ok(new ResultObj<>(ImmutableMap.of(1, unitsService.findBySubordinateNotOneself(authenticationUtils.getAuthentication().getCurrentUserInfo().getUnitsId()
            ))));
        }

    }

    @ApiOperation(value = "发起核查", notes = "对指定单位发起核查任务")
    @PostMapping("/confirm/startCheck")
    public ResponseEntity startNewCheck(@RequestBody CheckCheckVo ccVO) {

        List<CheckExamDetailVo> list = new ArrayList<>();
        CheckExamDetailVo checkExamDetailVo = new CheckExamDetailVo("", Collections.emptyList(), ccVO.getUnitRange(), ccVO.getRemark());
        list.add(checkExamDetailVo);

        CheckExamVo checkExamVo = new CheckExamVo(ccVO.getTitle(),
                ccVO.getEndTime(),
                ccVO.getUnitId(),
                0, list
        );

        startExam(checkExamVo, false);
        return ResponseEntity.ok("发起核查成功");

    }

    /**
     * 发起检查
     * <li>1. 添加发起核查bill记录</>
     * <li>2. 构建发起单位的统计账单与Task</>
     * <li>3. 构建被核查单位的详情账单与Task</li>
     *
     * @param ceVo 核查发起对象
     */
    @ApiOperation(value = "发起检查", notes = "手动发起核查，需要指定参数")
    @PostMapping("/confirm/startExam")
    public ResponseEntity<ResultObj> startExam(@RequestBody CheckExamVo ceVo,
                                               @RequestParam(defaultValue = "true", required = false) boolean isExam) {

        // 获取需要处理的代管单位集合
        List<Integer> esIds = checkUnitService.findAllEscrow().stream().map(Units::getUnitId).collect(toList());
        esIds.retainAll(ceVo.getDetail().get(0).getUnitIds());

        //设置截止时间
        ceVo.setEndTime(LocalDateTime.of(ceVo.getEndTime(), LocalTime.MAX).toLocalDate());
        //初始化数据结构
        List<Integer> detailIds = new ArrayList<>();
        Integer startUnitId = ceVo.getUnitId();
        Units startUnit = unitsRepo.findById(startUnitId).get();
        List<CheckExamDetailVo> examDetailVos = new ArrayList<>(ceVo.getDetail());

        //如果是create检查,那么不需要添加自己单位的自查,如果是update检查，那么需要添加单位的自查
        if (ceVo.getExamStatId() != 0) {
            //update
            log.info("[核查模块] update核查,自动添加id = {}市的自核查任务", startUnitId);
            examDetailVos.add(examDetailVos.get(0).copy(startUnitId, "由省核查发起的自检查"));
        }

        // 拼接检查组和检查组成员
        String groupUserString = "默认检查";

        List<Integer> unitIds = examDetailVos.stream().flatMap(cv -> cv.getUnitIds().stream()).collect(toList());
        List<Units> checkedUnits = unitsRepo.findAllById(unitIds);
        List<String> checkedUnitNames = checkedUnits.stream().map(Units::getName).collect(toList());

        // 2-1 构建发起单位的 统计账单
        DeviceCheckStat provinceCheckStat;
        //根据examStatId来判断是update还是create 此时初始化的为指定检查区域的数据

        provinceCheckStat = initStatData(checkedUnitNames,
                ceVo.getTitle(),
                groupUserString,
                0,
                0,
                startUnit.getName(),
                checkedUnits,
                ceVo.getEndTime().atStartOfDay());

        log.info("[核查模块]发起手动检查，发起单位为{},被查单位为{}", startUnit.getName(), checkedUnitNames);

        provinceCheckStat.setCheckType(isExam ? CheckType.CT_EXAM : CheckType.CT_CHECK);
        // statId 该任务为最上级的stat任务，如果是省发起就是省最上级的统计，市发起，则是市最上级的统计
        Integer statId = statRepo.save(provinceCheckStat).getId();

        // 2-2 构建发起单位的 统计任务
        // 根据examStatId来判断要不要重新创建任务
        Integer currentUserId = authenticationUtils.getAuthentication().getCurrentUserInfo().getUserId();
        TaskBto cityStatTask;

        cityStatTask = new Task(CHECK_EXAM_STAT_1.id,
                getUnitDateString(startUnit, ceVo.getTitle()),
                0, ".0.", CONFIRM_CHECK_STAT.id, statId, startUnitId)
                .parse2Bto();
        cityStatTask.setCustomInfo(isExam ? "exam" : "check");
        cityStatTask.getInvolveUserIdList().add(currentUserId);
        // 检查变为待办
        cityStatTask.getInvolveUserIdList().add(0);
        cityStatTask.setCurrentPoint(1);
        cityStatTask = taskService.start(cityStatTask);

        // 获取所有在库装备 ls == 2 or ls == 14
        Map<String, List<DeviceLibrary>> devInLib = dcService.getAllDeviceLibraryList().stream()
                .filter(d -> d.getLifeStatus() == 2 || d.getLifeStatus() == 14)
                .collect(groupingBy(DeviceLibrary::getOwnUnit));

        // 非在库装备 ls !=2 and ls !=14
        Map<String, List<DeviceLibrary>> devNotInLib = dcService.getAllDeviceLibraryList().stream()
                .filter(d -> d.getLifeStatus() != 2 && d.getLifeStatus() != 14)
                .collect(groupingBy(DeviceLibrary::getOwnUnit));


        // 3 如果是省级账户发起的检查，需要构建省局、省直属、市级的统计任务
        // 3-1 核查/检查，创建省局单位的账单及详情
        List<Integer> proList = checkedUnits.stream()
                .filter(o -> (o.getLevel() == 1 && o.getType() == 1) || (o.getLevel() == 1 && o.getType() == 2))
                .map(Units::getUnitId).collect(toList());

        if (checkUnitService.findExistDevice(proList).size() != 0) {

            // 3-1-1 创建省局单位的统计账单
            DeviceCheckStat proStat = new DeviceCheckStat(ceVo.getTitle(), "", LocalDateTime.now(), ceVo.getEndTime().atStartOfDay(),
                    "[]", 0, 0, "默认检查");
            proStat.setCheckType(isExam ? CheckType.CT_EXAM : CheckType.CT_CHECK);
            DeviceCheckStat proStatSave = statRepo.save(proStat);

            // 3-1-2 构建省局单位的任务
            TaskBto taskBtoPro = new Task(CHECK_EXAM_STAT_1.id,
                    "["+areaExhibitionCache.checkSpecial().get(1)+"]" + ceVo.getTitle(),
                    cityStatTask.getId(), ".0.", CONFIRM_CHECK_STAT.id, proStatSave.getId(), startUnitId)
                    .parse2Bto();
            taskBtoPro.setCustomInfo(isExam ? "exam" : "check");
            taskBtoPro.getInvolveUserIdList().add(currentUserId);
            // 检查变为待办
            taskBtoPro.getInvolveUserIdList().add(0);
            taskBtoPro.setCurrentPoint(1);
            // 不在代办中显示
            taskBtoPro.setExhibit("-1");
            taskBtoPro = taskService.start(taskBtoPro);

            // 3-1-3 构建省级单位的自查账单及任务
            List<Integer> unitsProIds = checkedUnits.stream()
                    .filter(o -> (o.getLevel() == 1 && o.getType() == 2) || (o.getType() == 1 && o.getLevel() == 1))
                    .map(Units::getUnitId)
                    .collect(toList());
            List<Units> unitsPro = unitsRepo.findAllById(checkUnitService.findExistDevice(unitsProIds));

            if (isExam) {
                unitsPro = unitsPro.stream().filter(o -> !(o.getLevel() == 1 && o.getType() == 1)).collect(toList());
            }

            log.info("[核查] 生成省局统计及详情:{}", unitsPro);

            for (Units unit : unitsPro) {

                DeviceCheckDetail unitDetailDoc = DeviceCheckDetail.EmptyWithChecker(
                        ceVo.getDetail().get(0).getRemark(),
                        ceVo.getTitle() + "%^&" + "省局单位检查任务",
                        0, 0, 0, 0,
                        unit.getName(),
                        unitsRepo.findByName(unit.getName()).getUnitId(),
                        devInLib.getOrDefault(unit.getName(), new ArrayList<>()),
                        devNotInLib.getOrDefault(unit.getName(), new ArrayList<>()));

                unitDetailDoc.setVar2(String.valueOf(CHECK_DETAIL_CITY_0.id));
                DeviceCheckDetail detail = detailRepo.save(unitDetailDoc);
                detailIds.add(detail.getId());
                // 将id放入统计中去 model ->  areaName -> detailId
                String areaName = auService.findOne(AuExample.UnitId, unit.getUnitId()).getName();

                // 3-2   构建被查单位的 自查任务 (根据被查单位的级别来区分是县级状态是市级状态)
                TaskBto checkedTask = new TaskBto(
                        CHECK_DETAIL_CITY_0.id,
                        getUnitDateString(unit, ceVo.getTitle()),
                        taskBtoPro.getId(),
                        addNode(taskBtoPro.getNodeIdDetail(), taskBtoPro.getId()),
                        CONFIRM_CHECK_DETAIL.id,
                        detail.getId(),
                        unit.getUnitId(),
                        0);
                checkedTask.setCustomInfo("manual");
                taskService.start(checkedTask);
            }
        }

        // 3-2 核查/检查,创建省直属单位的账单及详情
        List<Integer> escList = checkedUnits.stream()
                .filter(o -> o.getEscrow() == 1)
                .map(Units::getUnitId).collect(toList());
        if (checkUnitService.findExistDevice(escList).size() != 0) {
            // 3-2-1 创建省直单位的统计账单
            DeviceCheckStat esStat = new DeviceCheckStat(ceVo.getTitle(), "", LocalDateTime.now(), ceVo.getEndTime().atStartOfDay(),
                    "[]", 0, 0, "默认检查");
            esStat.setCheckType(isExam ? CheckType.CT_EXAM : CheckType.CT_CHECK);
            DeviceCheckStat esStatSave = statRepo.save(esStat);

            // 3-2-2 构建省直单位的任务
            TaskBto taskBtoEs = new Task(CHECK_EXAM_STAT_1.id,
                    "["+ areaExhibitionCache.checkSpecial().get(2) +"]" + ceVo.getTitle(),
                    cityStatTask.getId(), ".0.", CONFIRM_CHECK_STAT.id, esStatSave.getId(),
                    // 省直单位的检查任务应该给省里
                    unitsRepo.findAllByTypeAndLevel(1, 1).get(0).getUnitId()).parse2Bto();
            taskBtoEs.setCustomInfo(isExam ? "exam" : "check");
            taskBtoEs.getInvolveUserIdList().add(currentUserId);
            // 检查变为待办
            taskBtoEs.getInvolveUserIdList().add(0);
            taskBtoEs.setCurrentPoint(1);
            taskBtoEs = taskService.start(taskBtoEs);

            // 3-2-3 构建省直单位的自查账单及任务
            List<Units> unitsEs = checkedUnits.stream().filter(o -> o.getEscrow() == 1).collect(toList());
            unitsEs = unitsRepo.findAllById(checkUnitService.findExistDevice(unitsEs.stream().map(Units::getUnitId).collect(toList())));

            log.info("[核查] 生成省直属统计及详情:{}", unitsEs.toString());

            for (Units unit : unitsEs) {

                DeviceCheckDetail unitDetailDoc = DeviceCheckDetail.EmptyWithChecker(
                        ceVo.getDetail().get(0).getRemark(),
                        ceVo.getTitle() + "%^&" + "省直单位检查任务",
                        0, 0, 0, 0,
                        unit.getName(),
                        unitsRepo.findByName(unit.getName()).getUnitId(),
                        devInLib.getOrDefault(unit.getName(), new ArrayList<>()),
                        devNotInLib.getOrDefault(unit.getName(), new ArrayList<>()));

                unitDetailDoc.setVar2(String.valueOf(CHECK_DETAIL_CITY_0.id));
                DeviceCheckDetail detail = detailRepo.save(unitDetailDoc);
                detailIds.add(detail.getId());

                // 3-2   构建被查单位的 自查任务 (根据被查单位的级别来区分是县级状态是市级状态)
                TaskBto checkedTask = new TaskBto(
                        CHECK_DETAIL_CITY_0.id,
                        getUnitDateString(unit, ceVo.getTitle()),
                        taskBtoEs.getId(),
                        addNode(taskBtoEs.getNodeIdDetail(), taskBtoEs.getId()),
                        CONFIRM_CHECK_DETAIL.id,
                        detail.getId(),
                        // 省直单位的检查任务应该给省里
                        unitsRepo.findAllByTypeAndLevel(1, 1).get(0).getUnitId(),
                        0);
                checkedTask.setCustomInfo("manual");
                checkedTask.setExhibit("-1");
                taskService.start(checkedTask);
            }
        }

        // 3-3 检查，创建市单位的账单及详情,并且发起单位为省局

        if (isExam && checkTypeNum(ceVo.getDetail().get(0).getUnitIds(), 3)
                && (ceVo.getUnitId().equals(unitsRepo.findAllByTypeAndLevel(1, 1).get(0).getUnitId()))) {

            List<Units> unitsEs = checkedUnits.stream().filter(o -> o.getLevel() == 2).collect(toList());
            unitsEs = unitsRepo.findAllById(checkUnitService.findExistDevice(unitsEs.stream().map(Units::getUnitId).collect(toList())));
            log.info("[exam] 省级单位对市级单位发起检查，被检查的市级单位为:{}", unitsEs.stream().map(Units::getName).collect(toList()).toString());

            if (unitsEs.size() != 0) {

                // 3-1-1 创建市里的的统计账单
                DeviceCheckStat ciyStat = new DeviceCheckStat(ceVo.getTitle(), "", LocalDateTime.now(), ceVo.getEndTime().atStartOfDay(),
                        "[]", 0, 0, "默认检查");
                ciyStat.setCheckType(CheckType.CT_EXAM);
                DeviceCheckStat cityStatSave = statRepo.save(ciyStat);

                // 3-1-2 构建市单位的任务
                TaskBto taskBtoCity = new Task(CHECK_EXAM_STAT_1.id,
                        "[地方市单位]" + ceVo.getTitle(),
                        cityStatTask.getId(), ".0.", CONFIRM_CHECK_STAT.id, cityStatSave.getId(),
                        unitsRepo.findAllByTypeAndLevel(1, 1).get(0).getUnitId()).parse2Bto();
                taskBtoCity.setCustomInfo("exam");
                taskBtoCity.getInvolveUserIdList().add(currentUserId);
                // 检查变为待办
                taskBtoCity.getInvolveUserIdList().add(0);
                taskBtoCity.setCurrentPoint(1);
                taskBtoCity.setExhibit("-1");
                log.info("[check] 市级统计任务的状态是:{}", taskBtoCity.getBillStatus());
                TaskBto start = taskService.start(taskBtoCity);

                // 3-1-3 构建市单位的自查账单及任务

                for (Units unit : unitsEs) {

                    DeviceCheckDetail unitDetailDoc = DeviceCheckDetail.EmptyWithChecker(
                            ceVo.getDetail().get(0).getRemark(),
                            ceVo.getTitle() + "%^&" + "市级单位检查",
                            0, 0, 0, 0,
                            unit.getName(),
                            unit.getUnitId(),
                            devInLib.getOrDefault(unit.getName(), new ArrayList<>()),
                            devNotInLib.getOrDefault(unit.getName(), new ArrayList<>()));

                    unitDetailDoc.setVar2(String.valueOf(CHECK_DETAIL_CITY_0.id));
                    DeviceCheckDetail detail = detailRepo.save(unitDetailDoc);
                    detailIds.add(detail.getId());

                    // 3-2   构建被查单位的 自查任务 (根据被查单位的级别来区分是县级状态是市级状态)
                    TaskBto checkedTask = new TaskBto(
                            CHECK_DETAIL_CITY_0.id,
                            getUnitDateString(unit, ceVo.getTitle()),
                            start.getId(),
                            addNode(taskBtoCity.getNodeIdDetail(), taskBtoCity.getId()),
                            CONFIRM_CHECK_DETAIL.id,
                            detail.getId(),
                            // 将task给到市的每个单位
                            unit.getUnitId(),
                            0);
                    checkedTask.setCustomInfo("manual");
                    taskService.start(checkedTask);
                }

            }
        }

        // 3-4 核查,对市县进行核查的逻辑，需判断是否勾选了市级单位
        if (!isExam && (checkedUnits.stream().anyMatch(o -> o.getLevel() == 2))) {
            // 找到市相关的单位，包括市本级以及下级单位
            List<Units> units = checkedUnits.stream().filter(o -> o.getLevel() == 2)
                    .sorted(Comparator.comparing(Units::getShowOrder)).collect(toList());

            log.info("[核查] 核查，生成市的统计及详情:{}", units.toString());


            for (Units unit : units) {
                List<Integer> findCity = unitsService.findBySubordinateAll(unit.getUnitId()).stream().map(Units::getUnitId).collect(toList());
                // 过滤无装备的单位
                List<Integer> existUnits = checkUnitService.findExistDevice(findCity);

                if (existUnits.size() == 0) {
                    break;
                }

                // 1.创建市的统计账单及任务
                // 3-1-1 创建市里的的统计账单
                DeviceCheckStat ciyStat = new DeviceCheckStat(ceVo.getTitle(), "", LocalDateTime.now(), ceVo.getEndTime().atStartOfDay(),
                        "[]", 0, 0, "默认核查_市级统计任务");
                ciyStat.setCheckType(CheckType.CT_CHECK);
                DeviceCheckStat cityStatSave = statRepo.save(ciyStat);

                // 3-1-2 构建市单位的任务
                TaskBto taskBtoCity = new Task(CHECK_EXAM_STAT_1.id,
                        getUnitDateString(unit, ceVo.getTitle()),
                        cityStatTask.getId(), ".0.", CONFIRM_CHECK_STAT.id, cityStatSave.getId(),
                        unit.getUnitId()).parse2Bto();
                taskBtoCity.setCustomInfo("check");
                taskBtoCity.getInvolveUserIdList().add(currentUserId);
                // 检查变为待办
                taskBtoCity.getInvolveUserIdList().add(0);
                taskBtoCity.setCurrentPoint(1);
                log.info("[check] 核查创建市统计，状态为:{}", taskBtoCity.getBillStatus());
                taskBtoCity = taskService.start(taskBtoCity);

                // 2.创建单位的详情及任务
                // 3-1-3 构建市单位的自查账单及任务
                List<Units> unitsQu = unitsRepo.findAllById(existUnits).stream()
                        .sorted(Comparator.comparing(Units::getShowOrder)).collect(toList());

                for (Units qu : unitsQu) {

                    DeviceCheckDetail unitDetailDoc = DeviceCheckDetail.EmptyWithChecker(
                            ceVo.getDetail().get(0).getRemark(),
                            ceVo.getTitle() + "%^&" + "市级单位检查",
                            0, 0, 0, 0,
                            qu.getName(),
                            qu.getUnitId(),
                            devInLib.getOrDefault(qu.getName(), new ArrayList<>()),
                            devNotInLib.getOrDefault(qu.getName(), new ArrayList<>()));

                    unitDetailDoc.setVar2(qu.getLevel() == 2 ? String.valueOf(CHECK_DETAIL_CITY_0.id) : String.valueOf(CHECK_DETAIL_REGION_0.id));
                    DeviceCheckDetail detail = detailRepo.save(unitDetailDoc);
                    detailIds.add(detail.getId());

                    // 3-2   构建被查单位的 自查任务 (根据被查单位的级别来区分是县级状态是市级状态)
                    TaskBto checkedTask = new TaskBto(
                            qu.getLevel() == 2 ? CHECK_DETAIL_CITY_0.id : CHECK_DETAIL_REGION_0.id,
                            getUnitDateString(qu, ceVo.getTitle()),
                            taskBtoCity.getId(),
                            addNode(taskBtoCity.getNodeIdDetail(), taskBtoCity.getId()),
                            CONFIRM_CHECK_DETAIL.id,
                            detail.getId(),
                            // 将task给到市的每个单位
                            qu.getUnitId(),
                            0);
                    checkedTask.setCustomInfo("manual");
                    taskService.start(checkedTask);
                }
            }

        }

        // 判断当前登录用户是否为市级
        Optional<Units> byId = unitsRepo.findById(authenticationUtils.getAuthentication().getCurrentUserInfo().getUnitsId());
        boolean cityExam = false;
        if (byId.isPresent()) {
            if (byId.get().getLevel() == 2 && byId.get().getType() == 1) {
                cityExam = true;
            }
        }


        // 3-5 检查，创建区单位的账单及详情，只有市发起检查时才触发这里的代码
        if (checkTypeNum(ceVo.getDetail().get(0).getUnitIds(), 4) && isExam && cityExam) {

            // a 构建区单位的自查账单及任务
            List<Units> unitsEs = checkedUnits.stream().filter(o -> o.getLevel() == 3).collect(toList());
            log.info("[核查] 检查，生成区的统计及详情:{}", unitsEs.toString());
            unitsEs = unitsRepo.findAllById(checkUnitService.findExistDevice(unitsEs.stream().map(Units::getUnitId).collect(toList())));

            for (Units unit : unitsEs) {

                DeviceCheckDetail unitDetailDoc = DeviceCheckDetail.EmptyWithChecker(
                        ceVo.getDetail().get(0).getRemark(),
                        ceVo.getTitle() + "%^&" + "区级单位检查",
                        0, 0, 0, 0,
                        unit.getName(),
                        unit.getUnitId(),
                        devInLib.getOrDefault(unit.getName(), new ArrayList<>()),
                        devNotInLib.getOrDefault(unit.getName(), new ArrayList<>()));

                unitDetailDoc.setVar2(String.valueOf(CHECK_DETAIL_REGION_0.id));
                DeviceCheckDetail detail = detailRepo.save(unitDetailDoc);
                detailIds.add(detail.getId());

                // 3-2   构建被查单位的 自查任务 (根据被查单位的级别来区分是县级状态是市级状态)
                TaskBto checkedTask = new TaskBto(
                        CHECK_DETAIL_REGION_0.id,
                        getUnitDateString(unit, ceVo.getTitle()),
                        cityStatTask.getId(),
                        addNode(cityStatTask.getNodeIdDetail(), cityStatTask.getId()),
                        CONFIRM_CHECK_DETAIL.id,
                        detail.getId(),
                        // 将task给到市的每个单位
                        unit.getUnitId(),
                        0);
                checkedTask.setCustomInfo("manual");
                taskService.start(checkedTask);
            }
        }

        // 5. 重新设置并保存统计账单
        log.info("[核查模块] {}单位成功发起对 {} 单位的检查任务分发", startUnit.getName(), checkedUnitNames);
        return ResponseEntity.ok(new ResultObj<>(
                ImmutableMap.of("statIds", statId, "detailIds", detailIds),
                String.format("[核查模块] [%s]单位成功发起对 [%s] 单位的检查任务分发", startUnit.getName(), checkedUnitNames)
        ));
    }


    /**
     * @param initUnitNames 初始化指定单位的数据
     * @return
     */
    private DeviceCheckStat initStatData(List<String> initUnitNames, String title, String remark, Integer checkAId, Integer checkBId, String startUnitName, List<Units> unitsList, LocalDateTime endTime) {
        return new DeviceCheckStat(
                CheckType.CT_EXAM,
                title,
                startUnitName + "待核查装备统计单",
                "[]",
                checkAId,
                checkBId,
                remark,
                endTime);
    }

    private String getUnitDateString(Units units, String title) {
        return "[" + units.getUnitDesc() + "]" + title;

    }


    private String addNode(String originalNode, Integer fatherId) {
        return originalNode + fatherId + ".";
    }


    /**
     * 用于判断是否生成stat统计任务
     *
     * @param unitIds 传入的单位id
     * @return map
     */
    private boolean checkTypeNum(List<Integer> unitIds, Integer tag) {


        boolean rs = false;
        // tag: 0_处理核查时的省局，1_处理检查时的省局 2_处理省直属 3_处理市

        List<Units> units = unitsRepo.findAllById(unitIds);

        switch (tag) {
            case 0:
                // 核查 判断是否有省自己和省局单位
                if (units.stream().filter(o -> o.getType() == 1).filter(o -> o.getLevel() == 1).count() == 1) {
                    rs = true;
                }
                if (units.stream().filter(o -> o.getType() == 2).anyMatch(o -> o.getLevel() == 1)) {
                    rs = true;
                }
                break;
            case 1:
                // 检查不可能有省自己，因此只需要检查省局单位
                if (units.stream().filter(o -> o.getType() == 2).anyMatch(o -> o.getLevel() == 1)) {
                    rs = true;
                }
                break;
            case 2:
                // 检查是否有省直属单位
                if (units.stream().anyMatch(o -> o.getEscrow() == 1)) {
                    rs = true;
                }
                break;
            case 3:
                // 检查是否有市单位
                if (units.stream().anyMatch(o -> o.getLevel() == 2)) {
                    rs = true;
                }
                break;
            case 4:
                // 检查是否有区单位
                if (units.stream().anyMatch(o -> o.getLevel() == 3)) {
                    rs = true;
                }
                break;
            default:
                return false;
        }
        return rs;
    }

}
