package com.tykj.dev.device.confirmcheck.entity.domain;

import com.tykj.dev.misc.base.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * entity class for device_check_bill
 * 装备核查账单
 *
 * @author matrix
 */
@SuppressWarnings("ALL")
@Data
@Entity
@NoArgsConstructor
@ApiModel("装备核查账单")
@Table(name = "device_check_bill")
@EqualsAndHashCode(callSuper = true)
@SQLDelete(sql = "update device_check_bill set delete_tag = 1 where id = ?")
public class DeviceCheckBill extends BaseEntity {

    /**
     * 检查组成员1(省A岗)id
     */
    @Column(name = "userA_id")
    private Integer userAId;

    /**
     * 检查组成员2(省A岗)id
     */
    @ApiModelProperty(value = "检查组成员2(省A岗)id")
    @Column(name = "userB_id")
    private Integer userBId;

    /**
     * 核查状态(0:决算待审核,1:决算审核失败,2:决算中,3:决算完成)
     */
    private Integer checkStatus;

    /**
     * 核查单位主键id(x作为分隔符)，例如1x2,意为单位id为1和2的装备核查
     */
    @Column(name = "check_detail",columnDefinition = "TEXT")
    private String checkDetail;

    /**
     * 核查标题
     */
    @ApiModelProperty(value = "核查标题")
    private String checkTitle;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "区块链记录id")
    private String recordId;

    public DeviceCheckBill(Integer userAId, Integer userBId, Integer checkStatus, String checkDetail, String checkTitle, Date completeTime, String remark) {
        this.userAId = userAId;
        this.userBId = userBId;
        this.checkStatus = checkStatus;
        this.checkDetail = checkDetail;
        this.checkTitle = checkTitle;
        this.remark = remark;
    }

}
