package com.tykj.dev.device.confirmcheck.entity.domain;

import com.tykj.dev.device.confirmcheck.entity.vo.DeviceCheckLinkVo;
import com.tykj.dev.device.confirmcheck.entity.vo.LinkVo;
import com.tykj.dev.device.confirmcheck.utils.MapperHelper;
import com.tykj.dev.misc.base.BaseEntity;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.hibernate.annotations.SQLDelete;
import org.modelmapper.ModelMapper;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * DeviceCheckLink.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/9/23 at 5:40 下午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Entity
@SQLDelete(sql = "update device_check_link set delete_tag = 1 where id = ?")
@ApiModel("核查检查列表的缓存表")
@NoArgsConstructor
@Table(name = "device_check_link")
public class DeviceCheckLink extends BaseEntity {

    private Integer statId;

    @Column(name = "link_text", columnDefinition = "TEXT")
    private String linkText;

    public DeviceCheckLinkVo toVo() {
        ModelMapper mapper = MapperHelper.getMapper();
        DeviceCheckLinkVo dcLinkVo = mapper.map(this, DeviceCheckLinkVo.class);
        LinkVo linkVo = JacksonUtil.readValue(linkText, LinkVo.class);
        dcLinkVo.setLinkVo(linkVo);
        return dcLinkVo;
    }

    public DeviceCheckLink(Integer statId , String linkText) {
        this.statId = statId;
        this.linkText = linkText;
    }

    public DeviceCheckLink(Integer id, Integer createUserId, Integer updateUserId, LocalDateTime createTime, LocalDateTime updateTime, Integer deleteTag, Integer statId, String linkText) {
        super(id, createUserId, updateUserId, createTime, updateTime, deleteTag);
        this.statId = statId;
        this.linkText = linkText;
    }
}
