package com.tykj.dev.device.confirmcheck.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Collections;
import java.util.List;

/**
 * CheckExamDetailVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/1/12 at 4:19 下午
 */
@Data
@ApiModel("核查发起细节")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class CheckExamDetailVo {

    @ApiModelProperty(name = "核查组名称")
    private String groupName;

    @ApiModelProperty(name = "核查组成员名称")
    private List<String> userNames;

    @ApiModelProperty(name = "需要被检查的区域id")
    private List<Integer> unitIds;

    @ApiModelProperty(name = "备注")
    private String remark;

    public CheckExamDetailVo copy(Integer unitId,String remark) {
        return new CheckExamDetailVo(this.groupName, this.userNames, Collections.singletonList(unitId), remark);
    }
}
