package com.tykj.dev.device.confirmcheck.entity.vo;

import com.tykj.dev.device.confirmcheck.common.CheckType;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckStat;
import com.tykj.dev.misc.base.BeanHelper;
import com.tykj.dev.misc.utils.JacksonUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;
import org.springframework.util.CollectionUtils;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * DeviceCheckStatVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2020/8/15 at 7:13 下午
 */
@SuppressWarnings("ALL")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CheckStatVo {

    /**
     * 主键
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 父标题
     */
    private String title;

    /**
     * 子标题
     */
    private String subtitle;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    private LocalDateTime createTime;

    private LocalDateTime updateTime;

    @ApiModelProperty(name = "检查类型(0核查 1检查)")
    private Integer checkType;

    private Integer createUserId;

    private Integer updateUserId;

    private Integer checkUserAId;

    private Integer checkUserBId;

    private String checkUserAName;

    private String checkUserBName;

    private String remark;

    /**
     * 核查装备详情
     */
    private List<CheckDeviceStatVo> deviceStatVoList;


    public CheckStatVo(String remark, Integer checkUserAId, Integer checkUserBId, Integer id, String title, String subtitle, LocalDateTime startTime, LocalDateTime endTime, List<CheckDeviceStatVo> deviceStatVoList) {
        this.checkUserAId = checkUserAId;
        this.checkUserBId = checkUserBId;
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.startTime = startTime;
        this.endTime = endTime;
        this.deviceStatVoList = deviceStatVoList;
        this.remark = remark;
    }

    public static CheckStatVo empty() {
        List<CheckDeviceStatVo> emptyList = new ArrayList<>();
        return new CheckStatVo("", 0, 0, 0, "无指定数据", "无指定数据", null, null, emptyList);
    }

    public CheckStatVo cleanReduce(List<CheckDeviceStatVo> otherList) {
        if (CollectionUtils.isEmpty(deviceStatVoList)) {
            deviceStatVoList = otherList;
            return this;
        }

        //map key deviceModel+deviceName
        Map<String, CheckDeviceStatVo> oriModelMap = deviceStatVoList.stream()
                .collect(Collectors.toMap(d -> d.getDeviceModel()+d.getDeviceName(), Function.identity()));

        //遍历要加入的LIST 如果在源数据map中寻找到了则累加,否则添加进去
        for (CheckDeviceStatVo vo : otherList) {
            oriModelMap.computeIfPresent(vo.getDeviceModel()+vo.getDeviceName(), (k, v) -> v.cleanReduce(vo));
            oriModelMap.putIfAbsent(vo.getDeviceModel()+vo.getDeviceName(), vo);
        }

        deviceStatVoList = new ArrayList<>(oriModelMap.values());
        return this;
    }

    /**
     * Vo转Do
     */
    public DeviceCheckStat toDo() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        //复制基本信息
        DeviceCheckStat initialStat = mapper.map(this, DeviceCheckStat.class);
        //数据转JSON并赋值
        String jsonString = JacksonUtil.toJSon(this.deviceStatVoList);
        initialStat.setStatInfo(jsonString);
        if (this.checkType == 0){
            initialStat.setCheckType(CheckType.CT_CHECK);
        }else if (this.checkType == 1){
            initialStat.setCheckType(CheckType.CT_EXAM);
        }else {
            try {
                throw new Exception("[核查模块] 见到异常的checktype类型！id= " + this.checkType);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        return initialStat;
    }
}
