package com.tykj.dev.device.confirmcheck.entity.vo;

import com.alibaba.fastjson.JSON;
import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckLink;
import com.tykj.dev.device.confirmcheck.utils.MapperHelper;
import com.tykj.dev.misc.base.BaseVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.time.LocalDateTime;

/**
 * DeviceCheckLinkVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/9/24 at 10:58 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
public class DeviceCheckLinkVo extends BaseVo {

    private Integer statId;

    private LinkVo linkVo;

    public DeviceCheckLinkVo(Integer statId, LinkVo linkVo) {
        this.statId = statId;
        this.linkVo = linkVo;
    }

    public DeviceCheckLinkVo(Integer id, Integer createUserId, Integer updateUserId, LocalDateTime createTime, LocalDateTime updateTime, Integer deleteTag, Integer statId, LinkVo linkVo) {
        super(id, createUserId, updateUserId, createTime, updateTime, deleteTag);
        this.statId = statId;
        this.linkVo = linkVo;
    }

    public DeviceCheckLink toDo() {
        ModelMapper mapper = MapperHelper.getMapper();
        DeviceCheckLink dcLink = mapper.map(this, DeviceCheckLink.class);
        String linkText = JSON.toJSONStringWithDateFormat(this.linkVo, "yyyy-MM-dd HH:mm:ss");
        dcLink.setLinkText(linkText);
        return dcLink;
    }
}
