package com.tykj.dev.device.confirmcheck.entity.vo;

import com.tykj.dev.device.confirmcheck.entity.domain.DeviceCheckDetail;
import com.tykj.dev.misc.base.BeanHelper;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

/**
 * LinkCheckDetail.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/5/13 at 7:50 下午
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@Builder
public class LinkCheckDetail {

    /**
     * 检查业务ID
     */
    private Integer id;

    private String checkUnit;

    private String checkSituation;

    private String checkResult;

    private int remark;

    public LinkExamDetail toLed() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        LinkExamDetail detail = mapper.map(this, LinkExamDetail.class);
        detail.setExamName("");
        detail.setExamUser("");
        return detail;
    }
}
