package com.tykj.dev.device.confirmcheck.entity.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.List;

/**
 * StatLinkVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/5/13 at 7:43 下午
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel("统一跳转对象")
public class LinkVo {

    /**
     * 1 省统计 2 市检查 3 详情跳转
     */
    private int type;

    /**
     * 是否终结 true = 已终结 ,false = 未终结
     */
    private boolean isShutDown;

    /**
     * 核查/检查总标题
     */
    private String title;

    @JsonDeserialize(using = LocalDateDeserializer.class)
    @JsonSerialize(using = LocalDateSerializer.class)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd")
    private LocalDate endTime;

    /**
     * 里面装的都是检查数据
     */
    private List<LinkCheckDetail> lcDetail;

    /**
     * 里面装的都是自核查数据
     */
    private List<LinkExamDetail> leDetail;

    private int detailId;

    public LinkVo(int type, LocalDate endTime) {
        this.type = type;
        this.endTime = endTime;
    }

//    public LinkVo(int type, String title, String endTime, List<LinkCheckDetail> lcDetail, List<LinkExamDetail> leDetail, int detailId) {
//        this.type = type;
//        this.title = title;
//        this.endTime = LocalDate.parse(endTime);
//        this.lcDetail = lcDetail;
//        this.leDetail = leDetail;
//        this.detailId = detailId;
//    }
}
