package com.tykj.dev.device.confirmcheck.service;

import com.tykj.dev.device.confirmcheck.entity.vo.CheckUnitsExistVo;
import com.tykj.dev.device.user.subject.entity.Units;

import java.util.List;
import java.util.Map;

/**
 * @author Ozoz.L cnljj1995@gmail.com
 * on 11/10/21
 */
public interface CheckUnitService {


    /**
     *  查询核查/检查的单位
     *  包括省级、省本级、市
     * @param isExam true_过滤掉省(检查用)，false_不过滤省（核查用）
     * @return map
     */
    Map<Integer, List<Units>> findCheckUnit(boolean isExam);

    List<Units> checkPossible(List<Integer> ids, boolean isCheck);


    /**
     * 根据给定的单位给出没有装备的单位
     * @param ids 单位id
     * @return 没有装备的单位id
     */
    List<Integer> findUnExistDevice(List<Integer> ids);

    /**
     * 找出给定单位有装备的单位id
     * @param ids list of ids
     * @return object
     */
    List<Integer> findExistDevice(List<Integer> ids);

    /**
     * 获取所有代管戴单位
     * @return list
     */
    List<Units> findAllEscrow();
}
