package com.tykj.dev.device.confirmcheck.service.impl;

import com.google.common.collect.ImmutableMap;
import com.tykj.dev.device.confirmcheck.service.CheckUnitService;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.user.cache.UnitsCache;
import com.tykj.dev.device.user.subject.dao.AreaDao;
import com.tykj.dev.device.user.subject.dao.AreaExhibitionDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.Units;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * @author Ozoz.L cnljj1995@gmail.com
 * on 11/10/21
 */
@Slf4j
@Service
public class CheckUnitServiceImpl implements CheckUnitService {

    @Autowired
    private UnitsCache unitsCache;

    @Autowired
    private UnitsDao unitsRepo;

    @Autowired
    private AreaDao areaRepo;

    @Autowired
    private DeviceLibraryDao deviceRepo;

    @Autowired
    private AreaExhibitionDao AreaExRepo;

    @Override
    public Map<Integer, List<Units>> findCheckUnit(boolean isExam) {

        // 1 构建省级单位集合
        List<Units> provinceUnits = unitsRepo
                .findAllByTypeAndLevel(2, 1);

        // 过滤省局，逻辑为:如果不过滤，就加上省局
        if (!isExam) {
            List<Units> pro = unitsRepo.
                    findAllByTypeAndLevel(1, 1);
            provinceUnits.add(pro.get(0));

        }

        // 2 构建省直属单位集合
        List<Units> esAUnits = unitsRepo.findAllByEscrow(1).orElse(Collections.emptyList());

        // 3 构建市
        List<Units> cityUnits = unitsRepo.findAllByLevel(2);
        List<Units> checkCityUnits = new ArrayList<>();

        if (!isExam) {
            cityUnits.forEach(
                    units -> {units.setName(areaRepo.findNameById(units.getAreaId()));
                    checkCityUnits.add(units);
                    }
            );
        }
        log.info("[核查] 查询市单位:{}", checkCityUnits);

        return ImmutableMap.of(1, provinceUnits.stream().sorted(Comparator.comparing(Units::getShowOrder)).collect(toList()),
                2, esAUnits.stream().sorted(Comparator.comparing(Units::getShowOrder)).collect(toList()),
                3, isExam ? cityUnits.stream().sorted(Comparator.comparing(Units::getShowOrder)).collect(toList())
                        : checkCityUnits.stream().sorted(Comparator.comparing(Units::getShowOrder)).collect(toList()));
    }

    @Override
    public List<Units> checkPossible(List<Integer> ids, boolean isCheck) {

        if (isCheck) {
            return unitsRepo.findAllById(findUnExistDevice(ids));
        }

        List<Integer> rs = new ArrayList<>(ids);

        // 市本级id
        List<Integer> city = unitsRepo.findAllByLevel(2).stream().map(Units::getUnitId).collect(toList());

        // 市本级需要验证的id
        List<Integer> contains = ids.stream().filter(city::contains).collect(toList());

        for (Integer contain : contains) {
            List<Integer> collect = unitsCache.findByIdSubordinateAndOneself(contain).stream().map(Units::getUnitId).collect(toList());
            rs.addAll(collect);
        }
        // 去重
        List<Integer> unitsIds = findUnExistDevice(rs);
        return unitsRepo.findAllById(unitsIds.stream().distinct().collect(toList()));
    }


    @Override
    public List<Integer> findUnExistDevice(List<Integer> ids) {
        return ids.stream()
                .filter(id -> deviceRepo
                        .findAllByOwnUnit(
                                unitsRepo.findById(id)
                                        .orElse(Units.builder().name("未知").build()).getName())
                        .size() == 0)
                .collect(Collectors.toList());
    }

    @Override
    public List<Integer> findExistDevice(List<Integer> ids) {
        return ids.stream()
                .filter(id -> deviceRepo
                        .findAllByOwnUnit(
                                unitsRepo.findById(id)
                                        .orElse(Units.builder().name("未知").build()).getName())
                        .size() != 0)
                .collect(Collectors.toList());    }

    @Override
    public List<Units> findAllEscrow() {
        return unitsRepo.findAllByEscrow(1).orElse(Collections.emptyList());
    }
}
