package com.tykj.dev.device.confirmcheck.service.impl;

import com.google.common.collect.ImmutableMap;
import com.tykj.dev.device.confirmcheck.service.EscrowService;
import com.tykj.dev.device.library.repository.DeviceLibraryDao;
import com.tykj.dev.device.user.subject.dao.UnitsDao;
import com.tykj.dev.device.user.subject.entity.Units;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

import static java.util.stream.Collectors.toList;

/**
 * @author Ozoz.L cnljj1995@gmail.com
 * on 11/9/21
 */
@Service
public class EscrowServiceImpl implements EscrowService {

    @Autowired
    private UnitsDao unitsDao;
    @Autowired
    private DeviceLibraryDao deviceRepo;

    @Override
    public List<Units> findAllEscrowUnit(boolean filter) {
        List<Units> units = unitsDao.findAll().stream().filter(Units::isEscrow).collect(Collectors.toList());
        if (filter) {
            units = units.stream()
                    .filter(unit -> deviceRepo.findAllByOwnUnit(unit.getName()).size() != 0)
                    .collect(toList());
        }
        return units;
    }


    @Override
    public ImmutableMap checkPossible() {
        List<Units> units = unitsDao.findAll().stream().filter(Units::isEscrow).collect(Collectors.toList());
        List<String> unitsStr = units.stream()
                .filter(unit -> deviceRepo.findAllByOwnUnit(unit.getName()).size() == 0)
                .map(Units::getName).collect(toList());

        boolean findEmpty = unitsStr.isEmpty();

        StringBuilder alertString = new StringBuilder("[");
        if (!findEmpty) {
            for (String s : unitsStr) {
                alertString.append(s);
            }
        }

        return ImmutableMap.of("empty", findEmpty, "msg", alertString + "]代管单位没有装备数据，将不进行检查，是否继续！");
    }
}
