package com.tykj.dev.device.decommissioning.service;

import com.tykj.dev.device.decommissioning.entity.DeviceDecommissioningDetail;
import com.tykj.dev.device.decommissioning.entity.vo.DecommissioningOrderOutData;
import com.tykj.dev.device.decommissioning.entity.vo.StorageDeviceDevommissiong;
import com.tykj.dev.device.task.subject.bto.TaskBto;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDecommissioningBusinessService.java
 * @Description TODO
 * @createTime 2021年03月29日 16:37:00
 */
public interface DeviceDecommissioningBusinessService {

    /**
     * 退役任务保存草稿
     */
    TaskBto saveDeviceDecommissioningDraft(Integer userId, DecommissioningOrderOutData decommissioningOrderOutData);

    /**
     * 生成省中办退役的任务
     * @param userId 用户id
     * @param decommissioningOrderOutData 出库对象
     */
    DeviceDecommissioningDetail provinceSendDecommissioning(Integer userId, DecommissioningOrderOutData decommissioningOrderOutData);

    /**
     * 上传中办的回执单
     * @param taskId 任务ID
     * @param storageDeviceDevommissiong 单据 和装id对象
     */
    void receiptSingle(Integer taskId,  StorageDeviceDevommissiong storageDeviceDevommissiong);


    /**
     * 出库把任务推送至盖章审核
     */
    void sealOfAudit(Integer userId,DecommissioningOrderOutData orderOutData);

    /**
     * 出库盖章审核调用
     * 通过出库
     * 不通过 退回状态
     */
    void outSealOfAuditEnd(Integer taskId,Integer reviewTheResults);

    void deleteDrafts(Integer taskId);
}
