package com.tykj.dev.device.decommissioning.service;

import com.tykj.dev.device.decommissioning.entity.DeviceDecommissioningDetail;
import com.tykj.dev.device.decommissioning.entity.vo.DecommissioningSelectVo;
import com.tykj.dev.device.file.entity.FileRet;
import org.springframework.data.domain.Page;

import java.util.List;
import java.util.Map;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceDecommissioningDetailService.java
 * @Description TODO
 * @createTime 2021年03月29日 16:18:00
 */
public interface DeviceDecommissioningDetailService {

    /**
     * 添加清退详情
     * @return 清退详情对象
     */
    DeviceDecommissioningDetail saveDeviceDecommissioningDetail(DeviceDecommissioningDetail deviceDecommissioningDetail);

    /**
     * 根据清退详情id查询清退详情
     * @param decommissioningId 退役详情id
     * @return 详情对象
     */
    DeviceDecommissioningDetail findDeviceDecommissioningDetail(Integer decommissioningId);

    /**
     * 根据清退详情id查询清退详情（不包括装备详情）
     * @param decommissioningId 退役详情id
     * @return 详情对象
     */
    DeviceDecommissioningDetail findDeviceDecommissioningDetailNoDev(Integer decommissioningId);

    List<DeviceDecommissioningDetail> findAll();

    DeviceDecommissioningDetail findApplyId(Integer applyId);

    Page<DeviceDecommissioningDetail> findPageDeviceDecommissioningDetail(DecommissioningSelectVo decommissioningSelectVo);


    Map<String, List<FileRet>> findByIdToFileMapList(Integer id);
}
