package com.tykj.dev.device.destroy.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.destroy.entity.vo.DestroySelectVo;
import com.tykj.dev.device.destroy.service.DeviceDestroyQueryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

/**
 * @author huangxiahao
 */
@RestController
@RequestMapping(value = "/destroyQuery")
@AutoDocument
@Api(tags = "销毁查询模块", value = "销毁查询模块")
public class DeviceDestroyQueryController {
    @Autowired
    DeviceDestroyQueryService deviceDestroyQueryService;

    /**
     * 根据任务id查询销毁业务
     */
    @ApiOperation(value = "根据任务id查询销毁业务", notes = "根据任务id查询销毁业务")
    @PostMapping(value ="/findTaskId/{taskId}")
    public ResponseEntity findTaskId(@PathVariable Integer taskId){
        return ResponseEntity.ok(deviceDestroyQueryService.findTaskId(taskId));
    }

    /**
     * 根据ApplyId查询销毁任务
     */
    @GetMapping(value ="/findApplyIdToDeviceDestroyTask/{applyId}")
    @ApiOperation(value = "根据ApplyId查询销毁任务", notes = "根据ApplyId查询销毁任务")
    public ResponseEntity findApplyIdToDeviceDestroyTask(@PathVariable Integer applyId){
        return ResponseEntity.ok(deviceDestroyQueryService.findApplyIdToDeviceDestroyTask(applyId));
    }

    /**
     * 业务办理档案接口
     */
    @PostMapping(value ="/findPageDeviceDecommissioningDetail")
    @ApiOperation(value = "业务办理档案接口", notes = "业务办理档案接口调用")
    public ResponseEntity findApplyIdToDecommissioningTask(@RequestBody DestroySelectVo destroySelectVo){
        return ResponseEntity.ok(deviceDestroyQueryService.findPageDeviceDestroyBill(destroySelectVo));
    }

    @GetMapping(value ="/repel/fileMap/{taskId}")
    @ApiOperation(value = "根据任务ID查询业务相关单据", notes = "根据任务ID查询业务相关单据")
    public ResponseEntity repelFileMap( @PathVariable Integer taskId){
        return ResponseEntity.ok(deviceDestroyQueryService.findByTaskIdToFileMapList(taskId));
    }
}
