package com.tykj.dev.device.destroy.entity.vo;

import com.tykj.dev.device.destroy.entity.domain.DeviceDestroyBill;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import com.tykj.dev.misc.base.BeanHelper;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.modelmapper.ModelMapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for device_destroy_bill
 * 装备销毁账单
 *
 * @author zjm
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("装备销毁vo")
public class DeviceDestroyBillVo {

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "申请id")
    private Integer applyId;

    @ApiModelProperty(value = "单据编号")
    private String num;

    @ApiModelProperty(value = "申请文号")
    private String applyNumber;

    @ApiModelProperty(value = "批复文号")
    private String replayNumber;

    @ApiModelProperty(value = "监销人")
    private String supervisor;

    @ApiModelProperty(value = "主管领导")
    private String leader;

    @ApiModelProperty(value = "承办人")
    private String undertaker;

    @ApiModelProperty(value = "经办人")
    private String agent;

    @ApiModelProperty(value = "销毁日期")
    private Date destroyTime;

    @ApiModelProperty(value = "单位Id")
    private Integer unitId;

    @ApiModelProperty(value = "单据数据集合")
    private List<ScriptSaveVo> scripts = new ArrayList<>();

    @ApiModelProperty(value = "申请文件集合")
    private List<FileRet> applyFileList;

    @ApiModelProperty(value = "批复文件集合")
    private List<FileRet> replayFileList;

    @ApiModelProperty(value = "销毁文件集合")
    private List<FileRet> destructionFileList;

    @ApiModelProperty(value = "任务id")
    private Integer taskId;

    private String unitName;

    @ApiModelProperty(value = "操作人id")
    private Integer operationId;

    public DeviceDestroyBill toDeviceDestroyBill() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, DeviceDestroyBill.class);
    }

}
