package com.tykj.dev.device.file.entity;

import com.tykj.dev.device.library.subject.vo.ScriptSaveVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Documents.java
 * @Description 出库入库单据样式
 * @createTime 2021年01月25日 10:16:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@ApiModel(value = "出库入库单据样式", description = "出库入库单据属性实体")
public class Documents {

    @ApiModelProperty
    private Integer id;

    @ApiModelProperty(value = "单据号")
    private String number;

    @ApiModelProperty(value = "单据标题")
    private String title;

    @ApiModelProperty(value = "接收单位")
    private String receiveUnit;

    @ApiModelProperty(value = "批复文号")
    private String replyNum;

    @ApiModelProperty(value = "相关装备")
    private List<DocumentDevice> documentDevices;

    @ApiModelProperty(value = "发件单位")
    private String senderUnit;

    @ApiModelProperty(value = "签章数据")
    private String srcA;

    @ApiModelProperty(value = "签章数据")
    private String srcB;

    @ApiModelProperty(value = "发件方经办人")
    private String nameA;

    @ApiModelProperty(value = "发件方经办人")
    private String nameA1;

    @ApiModelProperty(value = "接收方人员")
    private String nameB;

    @ApiModelProperty(value = "接收方人员")
    private String nameB1;

    @ApiModelProperty(value = "后端转换使用")
    private List<ScriptSaveVo> scriptSaveVos;

    @ApiModelProperty(value = "发送方人员签字base64")
    private String userSrcA1;

    @ApiModelProperty(value = "发送方人员签字base64")
    private String userSrcA2;

    @ApiModelProperty(value = "接收方人员签字base64")
    private String userSrcB1;

    @ApiModelProperty(value = "接收方人员签字base64")
    private String userSrcB2;

    public Documents(String number, String title, String receiveUnit, String replyNum, String senderUnit, String srcA, String srcB, String nameA, String nameA1, String nameB, String nameB1, List<ScriptSaveVo> scriptSaveVos) {
        this.number = number;
        this.title = title;
        this.receiveUnit = receiveUnit;
        this.replyNum = replyNum;
        this.senderUnit = senderUnit;
        this.srcA = srcA;
        this.srcB = srcB;
        this.nameA = nameA;
        this.nameA1 = nameA1;
        this.nameB = nameB;
        this.nameB1 = nameB1;
        this.scriptSaveVos = scriptSaveVos;
    }
}
