package com.tykj.dev.device.library.service;

import com.tykj.dev.config.UpdateCache;
import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import com.tykj.dev.device.library.subject.vo.*;
import com.tykj.dev.device.user.util.DecryptMD5;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
public interface DeviceLibraryService {

    /**
     * @param deviceLibraryEntity 添加装备
     */
    DeviceLibrary addEntity(DeviceLibrary deviceLibraryEntity);

    /**
     * @param deviceLibraries 异步上链
     */
    void sendHash(List<DeviceLibrary> deviceLibraries);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取装备分页
     */
    Page<DeviceLibrary> getPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取标签管理分页
     */
    List<DeviceLibrary> getTagPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     */
    List<DeviceLibrary> getCoreDevicePage(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     * @param pageable              获取装备统计分页
     */
    List<DeviceStatisticsVo> getDeviceStatisticsPage(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable, Sort sort);
//    /**
//     * @param deviceLibrarySelectVo 装备查询vo
//     * @param pageable              获取装备统计分页
//     */
//    List<DeviceStatisticsVo> getDeviceStatisticsPageAndSort(DeviceLibrarySelectVo deviceLibrarySelectVo, Pageable pageable);
    /**
     * 获取所有存在的装备名称
     */
    List<String> getAllName();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取单位装备列表
     */
    List<DeviceLibrary> getList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取所有区域装备列表
     */
    List<DeviceLibrary> getAllList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 获取单位自查装备在库列表
     */
    List<DeviceLibrary> getCheckList();

    /**
     * 获取单位自查未在库装备列表
     */
    List<DeviceLibrary> getNotInStockList();

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              获取可配发装备列表
     */
    List<DeviceLibrary> getAllotList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * @param id 入库单id
     *           根据入库单Id查询装备列表
     */
    List<DeviceLibrary> getListByBillId(Integer id);

    /**
     * @param deviceLibraryEntity 更新装备信息
     */
    DeviceLibrary update(DeviceLibrary deviceLibraryEntity);

    /**
     * @param id 装备主键Id
     *           通过id查询某件装备
     */
    DeviceLibrary getOne(Integer id);

    /**
     * @param id 装备主键id
     *           逻辑删除某件装备
     */
    void delete(Integer id);

    /**
     * @param deviceLibrarySelectVo 装备查询vo
     *                              不以父子结构返回单位装备列表
     */
    List<DeviceLibrary> getListWithoutParent(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 查询拥有装备的所有单位
     */
    List<String> getAllUnit();

    /**
     * 查询在库所有装备的型号
     */
    List<String> getAllInLibraryModels();

    /**
     * 查询可清退装备
     */
    List<DeviceLibrary> getSendBackDevice(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 判断装备状态是否在库（若不是抛出303异常）
     */
    void isInStock(List<Integer> ids);

    /**
     * 判断装备状态是否待退役（若不是抛出303异常）
     */
    void isWaitRetired(List<Integer> ids);

    /**
     * 判断装备状态是否在库或待退役（若不是抛出303异常）
     */
    void isInStockOrWaitRetired(List<Integer> ids);


    /**
     * 判断装备状态是否丢失（若不是抛出303异常）
     * @param ids
     */
    void isNotLoss(List<Integer> ids);

    /**
     * 判断装备状态是否在库或维修中（若不是抛出303异常）
     */
    void isInStockOrRepairing(List<Integer> ids);

    void isFirstRepair(List<Integer> ids);

    int getDeviceCount();

    /**
     * 获取所有装备id map
     */
    Map<Integer,DeviceLibrary> getAllDeviceMap();

    /**
     * 获取所有装备序列号map
     */
    Map<String,DeviceLibrary> getAllDeviceSeqMap();

    /**
     * 根据单位 以及生命状态集合 查询设备数量
     */
    Integer countAllRepel(List<Integer> fieldingIds,List<String> unitNames,List<String> seqNums,List<Integer> lifeStatusList);

    List<DeviceLibrary> findAllBySeqNumber(List<String> seqNumbers);

    /**
     * 判断装备序列号中是否有不等于指定的leftStatus的装备
     * 有则返回303给前端提示
     */
    void judgeSeqNumbersInNotEqualLifeStatus(List<String> seqNumbers,Integer leftStatus);

    /**
     * 根据装备id集合查询出所有的装备
     */

    List<DeviceLibrary> getAllDevByDevIds(List<Integer> ids);

    /**
     * @param lifeStatus 更新装备生命信息
     */
    void updateLifeStatus(Integer lifeStatus,Integer id);

    /**
     * @param lifeStatus 更新装备生命信息
     */
    void updateLifeStatus2(Integer lifeStatus,List<Integer> ids);

    List<DeviceLibrary> findByIds(List<Integer> ids);

    /**
     * @param seqNumber 序列号
     */
    DeviceLibrary findBySeqNumber(String seqNumber);

    /**
     * 得到所有的装备
     */
    List<DeviceLibrary> getAllDeviceList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 通过列装id查询所有装备
     */
    List<DeviceLibrary> findAllByPackingId(Integer packingId);

    /**
     * 通过列装id查询所有装备
     */
    List<DeviceLibrary> findAllByPackingIdsIn(List<Integer> packingIds,Pageable pageable);
    List<DeviceLibrary> findAllByPackingIdsIn(List<Integer> packingIds);

    /**
     * 根据partParentId查询附件
     * @param id  装备的id
     */
    List<DeviceLibrary> findAllByPartParentId(Integer id);

    /**
     * 通过列装id查询所有装备
     */
//    List<DeviceLibrary> findAllByPackingId2(List<Integer> packingIds);

    Map<Integer,List<DeviceLibrary>> findAllByPackingId3();

    /**
     * 批量更新装备
     * @param
     * @param
     */
    void batchUpdateDevices(String oldModel,String newModel);
    /**
     * 通过型号查询装备
     */
    List<DeviceLibrary> findAllByModel(String model);

    /**
     * @param deviceIds 装备id
     */
    void updateDevicesOwnUnit(List<Integer> deviceIds);

    /**
     * @param localUnit 所在单位
     * @param deviceIds 装备id的集合
     */
    void updateLocalAndOwn(String localUnit,List<Integer> deviceIds);

    /**
     * 根据型号查询序列号 取最大值的Device对象
     */
    int getMaxSeqNumber(String model);


    List<DeviceLibrary> findAllDeviceLibraryList();

    List<String> getMaxPartSeqNumber(String model,Integer isPart);


    /**
     * 通过 packing 查询装备
     * @param packing 列装id
     * @return
     */
    List<DeviceLibrary> findDevicesByPacking(Integer packing);

    /**
     * 更新配用范围
     * @param libraries 装备的集合
     */
    void updateMatchingRange(List<DeviceLibrary> libraries);

    /**
     * 装备的解除
     * @param deviceId 装备id
     */
//    void relieveDevice(int deviceId);

//    /**
//     * 装备的绑定
//     * @param
//     */
//    void bindingDevice(BindingDeviceVo bindingDeviceVo);

    /**
     * 以下接口都为缓存做铺垫
     */
    /**
     * 更新设备序列号
     * @param taskId 任务id
     * @param seqNumbers 序列号的集合
     */
    void upDateSeqNumbersApplyTaskId(Integer taskId,List<String> seqNumbers);

    List<DeviceLibrary> findAllByOwnUnit(String ownUnit);

    List<DeviceLibrary> getAllByRfidCardId(String rfidCardId);

    /**
     * 根据装备id的集合更新装备的生命状态
     * @param lifeStatus 生命状态
     * @param idList 装备id的集合
     * @return
     */
    int upDateLeftStatus(Integer lifeStatus,@Param("idList") List<Integer> idList);

    /**
     * 根据装备id的集合更新装备的生命状态
     * @param lifeStatus 生命状态
     * @param seqNumbers  装备序列号的集合
     * @return 影响行数
     */
    int upDateSeqNumbersLeftStatus(Integer lifeStatus,@Param("seqNumbers") List<String> seqNumbers);

    /**
     * 根据装备id的集合更新装备的生命状态和lock
     * @param lifeStatus 生命状态
     * @param lock 是否解锁
     * @param idList 装备id的集合
     * @return 影响行数
     */
    int upDateLeftStatusAndLockStatus(Integer lifeStatus,Integer lock,@Param("idList") List<Integer> idList);

    /**
     * 根据装备id的集合更新lock
     * @param lock 解锁
     * @param idList 装备id的集合
     * @return 影响行数
     */
    int upDateLockStatus(Integer lock,@Param("idList") List<Integer> idList);

    /**
     * 根据装备id的集合更新生命状态和单位名称
     * @param lifeStatus
     * @param unitName
     * @param lock
     * @param idList
     * @return 影响行数
     */
    int upDateLeftStatusAndUnitNameAndLockStatus(Integer lifeStatus,String unitName,Integer lock,@Param("idList") List<Integer> idList);

    /**
     * 根据装备的序列号的集合更新生命状态和单位名称和锁
     * @param lifeStatus 生命状态
     * @param unitName 单位名称
     * @param lock 锁
     * @param seqNumbers 装备序列号的集合
     * @return 影响行数
     */
    int upDateSeqNumbersLeftStatusAndUnitNameAndLockStatus(Integer lifeStatus,String unitName,Integer lock,@Param("seqNumbers") List<String> seqNumbers);

    /**
     * 根据装备id的集合更新生命状态和所属单位
     * @param lifeStatus 生命状态
     * @param unitName 所属单位
     * @param idList 装备id的集合
     * @return 影响行数
     */
    int upDateLeftStatusAndOwnUnitName(Integer lifeStatus,String unitName,@Param("idList") List<Integer> idList);

    /**
     * 根据装备id的集合更新RFID表面号
     * @param idList 装备id的集合
     * @return 影响行数
     */
    int upDateRfidSurfaceIdAsSeqNumber(@Param("idList") List<Integer> idList);

    /**
     * 根据列装id更新名称
     * @param name 名称
     * @param packingId 列装id
     * @return 影响行数
     */
    int upDateName(String name,Integer packingId);

    /**
     * 根据列装id更新配用范围
     * @param matchingRange 配用范围
     * @param packingId 列装id
     * @return 影响函数
     */
    int upDateMatchingRange(Integer matchingRange,Integer packingId);

    /**
     * 根据装备id更新生命状态
     * @param lifeStatus 生命状态
     * @param id 装备id
     * @return
     */
    int batchUpdate(Integer lifeStatus,Integer id);

    /**
     * 根据装备id更新生命状态
     * @param lifeStatus 生命状态
     * @param ids 装备id的集合
     * @return
     */
    int batchUpdate2(Integer lifeStatus,List<Integer> ids);

    /**
     * 根据列装id更新配用范围
     * @param matchingRange 配用范围
     * @param packingId 列装id
     * @return 影响行数
     */
    int updateMatchingRange(Integer matchingRange,Integer packingId);

    /**
     * 根据列装id更新配用范围
     * @param matchingRange 配用范围
     * @param deviceIds 装备id的集合
     * @return 影响行数
     */
    int updateMatchingRange2(Integer matchingRange,@Param("deviceIds") List<Integer> deviceIds);

    /**
     * 更新型号和列装id
     * @param newModel 新的型号
     * @param packingId 列装id
     * @param deviceIds 装备id集合
     * @return 影响行数
     */
    int updateModelAndPackingId(String newModel,Integer packingId,List<Integer> deviceIds);

    /**
     * 根据装备id的集合更新列装id
     * @param packingId 列装id
     * @param deviceIds 装备id的集合
     * @return 影响行数
     */
    int updatePackingId(Integer packingId,List<Integer> deviceIds);
    /**
     * 查询所有装备
     */
    List<DeviceLibrary> findAllDevices();

    /**
     * 根据装备id的集合更新列装id
     * @param deviceIds 装备id的集合
     */

    void updatePartParentId(List<Integer> deviceIds);


    /**
     * 装备进行解绑
     * @param deviceLibraries 装备附件的集合
     */
    void unboundDevice(List<DeviceLibrary> deviceLibraries);

    /**
     * 装备绑定
     * @param bindingDeviceVo 装备绑定的vo
     */
    void boundDevice(BindingDeviceVo bindingDeviceVo);

    /**
     * 根据rfid查询装备
     * @return 装备的集合
     */
    List<DeviceLibrary> getAllBySeqNumber(String rfid);


    /**
     * 根据id集合查询装备
     * @param ids 装备id的集合
     */
    List<DeviceLibrary> findAllByIds(List<Integer> ids);

    /**
     * 更新装备的状态  正式和试用
     */
    void updateTry(List<DeviceLibrary> deviceLibraries);

    /**
     * 获取所有装备的集合
     * @param deviceLibrarySelectVo 查询装备的vo
     * @return 所有装备
     */
    List<DeviceLibrary> getAlldevList(DeviceLibrarySelectVo deviceLibrarySelectVo);

    /**
     * 根据装备id更新装备
     * @param deviceForApplyVos 更新试用装备序列号的vo
     */
    void updateSeqNumber(List<DeviceForApplyVo> deviceForApplyVos);


    void updateStorageLocation(UpdateStorageLocationVo updateStorageLocationVo);

    /**
     * 查询装备给工作交接使用
     * @return  WorkUseVos
     */
    List<WorkUseVo> getDevicesForWorkUse();


    /**
     * 修改单位名称则装备的所属所在也需要进行修改
     * @param updateUnitVo 修改单位名称的vo
     */
    void updateDeviceLocationAndOwnUnit(UpdateUnitVo updateUnitVo);

    /**
     * @param unitId 单位id
     */
    List<DeviceLibrary> getDeviceByUnitNameAll(Integer unitId);

}
