package com.tykj.dev.device.library.subject.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceExcelVo.java
 * @Description TODO
 * @createTime 2021年06月28日 13:06:00
 */
@Data
@ApiModel("装备库")
@AllArgsConstructor
@NoArgsConstructor
public class DeviceExcelVo {

    /**
     * 型号
     */
    @Excel(name = "型号", orderNum = "1", width = 30, needMerge = true)
    @ApiModelProperty(value = "型号")
    private String model;

    /**
     * 装备名称
     */
    @Excel(name = "装备名称", orderNum = "2", width = 30, needMerge = true)
    @ApiModelProperty(value = "装备名称")
    private String name;

    @ApiModelProperty(value = "密级")
    @Excel(name = "密级", orderNum = "3", width = 30, needMerge = true)
    private String secretLevelName;

    /**
     * 装备序列号
     */
    @Excel(name = "装备序列号", orderNum = "4", width = 30, needMerge = true)
    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;
//    /**
//     * 生产序列号
//     */
//    @Excel(name = "区域名称", orderNum = "1", width = 30, needMerge = true)
//    @ApiModelProperty(value = "生产序列号")
//    private String prodNumber;

    /**
     * 所在单位
     */
    @Excel(name = "所在单位", orderNum = "5", width = 30, needMerge = true)
    @ApiModelProperty(value = "所在单位")
    private String locationUnit;
    /**
     * 所属单位
     */
    @Excel(name = "所属单位", orderNum = "6", width = 30, needMerge = true)
    @ApiModelProperty(value = "所属单位")
    private String ownUnit;


    @ApiModelProperty(value = "装备存放位置",notes = "默认是库房")
    @Excel(name = "装备存放位置", orderNum = "7", width = 30, needMerge = true)
    private String storageLocation;


    @ApiModelProperty(value = "配用范围")
    @Excel(name = "配用范围", orderNum = "8", width = 30, needMerge = true)
    private String matchingRangeName;


    @ApiModelProperty(value = "生命状态")
    @Excel(name = "生命状态", orderNum = "9", width = 30, needMerge = true)
    private String lifeStatusName;


}
