package com.tykj.dev.device.library.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author zsp
 */
@Repository
@Data
@ApiModel("更新试用装备序列号的vo")
public class DeviceForApplyVo {

    @NotNull(message = "deviceId不能为空")
    @Min(value = 1,message = "deviceId不能小于1")
    @ApiModelProperty(value = "装备id", example = "1")
    private Integer deviceId;

    @ApiModelProperty(value = "装备的序列号", example = "12344")
    private String seqNumber;

    @ApiModelProperty(value = "是否修改 0 正式  1 试用", example = "0")
    private Integer isUpdate;

}
