package com.tykj.dev.device.library.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("装备存储类")
@Repository
public class DeviceLibrarySaveVo {

    @NotNull(message = "packingId不能为空")
    @Min(value = 1,message = "packingId不能小于1")
    @ApiModelProperty(value = "列装id", example = "0")
    private Integer packingId;

    @NotNull(message = "seqNumber不能为空")
    @ApiModelProperty(value = "装备序列号")
    private String seqNumber;

//    @NotNull(message = "prodNumber不能为空")
    @ApiModelProperty(value = "生产序列号")
    private String prodNumber;

    @NotNull(message = "rfidSurfaceId不能为空")
    @ApiModelProperty(value = "rfid表面号")
    private String rfidSurfaceId;

//    @NotNull(message = "rfidCardId不能为空")
    @ApiModelProperty(value = "rfid卡号")
    private String rfidCardId;

    @NotNull(message = "storageType不能为空")
    @ApiModelProperty(value = "入库类型，1-横向，2-纵向")
    private Integer storageType;

    @ApiModelProperty(value = "配发类型，1-横向，2-纵向")
    private Integer allotType;

    @NotNull(message = "manageStatus不能为空")
    @ApiModelProperty(value = "管理状态,0-不再所属单位,1-在所属单位")
    private Integer manageStatus;

    @ApiModelProperty(value = "是不是单独的配件,0-不是,1-是")
    private Integer isSinglePart = 1;

    @ApiModelProperty(value = "货架位置")
    private String position;

    @ApiModelProperty(value = "是否需要绑定",notes = "0 是绑定, 1 是未绑定")
    private Integer isBinding = 0;

    @ApiModelProperty(value = "装备存放位置",notes = "默认是库房")
    private String storageLocation;

    @ApiModelProperty(value = "装备存放位置的id",notes = "默认是库房id")
    private Integer storageLocationId;

    @ApiModelProperty(value = "是否是试用装备",notes = "0 是正式  1 是测试")
    private Integer tryOutDevice = 0;

    @ApiModelProperty(value = "试用装备数量")
    private Integer tryOutDeviceNum ;
}
