package com.tykj.dev.device.library.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * DATE:2021-8-10
 * Author:zsp
 */
@Data
@ApiModel("装备vo")
@AllArgsConstructor
@NoArgsConstructor
public class DeviceNewVo {

    @ApiModelProperty(value = "型号", example = "bmxx")
    public String model;

    @ApiModelProperty(value = "名称", example = "BM-1")
    public String name;

    @ApiModelProperty(value = "配用范围")
    public String matchingRangeName;

    @ApiModelProperty(value = "装备形态")
    public String typeName;

    @ApiModelProperty(value = "数量")
    public Integer num;

    @ApiModelProperty(value = "所属单位", example = "省机要局")
    private String ownUnit;

    @ApiModelProperty("组织架构级别")
    private Integer level;

    @ApiModelProperty(value = "装备id")
    private List<Integer> devicesId;

    @ApiModelProperty("是否是配件")
    private Integer isPart;

}
