package com.tykj.dev.device.library.subject.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zsp
 */
@Data
@ApiModel("本级装备统计类")
public class LocalDeviceStatisticsVo {

    @ApiModelProperty(value = "型号", example = "bmxx")
    public String model;

    @ApiModelProperty(value = "名称", example = "BM-1")
    public String name;

    @ApiModelProperty(value = "所属单位", example = "省机要局")
    private String ownUnit;

    @ApiModelProperty(value = "装备类型总数", example = "100")
    private Integer deviceNumber;

    @ApiModelProperty(value = "在库数量", example = "10")
    private Integer inLibraryNum;

    @ApiModelProperty(value = "维修数量", example = "10")
    private Integer repairNum;

    @ApiModelProperty(value = "销毁数量", example = "10")
    private Integer destoryNum;

    @ApiModelProperty(value = "退役数量", example = "10")
    private Integer retiredNum;

    @ApiModelProperty(value = "报废数量", example = "10")
    private Integer scrappedNum;

    @ApiModelProperty(value = "运输中数量", example = "10")
    private Integer allotNum;

    @ApiModelProperty(value = "使用数量", example = "10")
    private Integer useNum;

    @ApiModelProperty(value = "其他数量", example = "10")
    private Integer otherNum;

    @ApiModelProperty(value = "其他数量id", example = "10")
    private List<Integer> otherNumIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号所有装备Id列表")
    private List<Integer> deviceIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号在库装备Id列表")
    private List<Integer> inLibraryIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号维修装备Id列表")
    private List<Integer> repairIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号销毁装备Id列表")
    private List<Integer> destoryIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号退役装备Id列表")
    private List<Integer> retiredIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号报废装备Id列表")
    private List<Integer> scrappedIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号运输中装备Id列表")
    private List<Integer> allotIds = new ArrayList<>();

    @ApiModelProperty(value = "该型号使用中装备Id列表")
    private List<Integer> useIds = new ArrayList<>();

    @ApiModelProperty(value = "序列号区间")
    public String seqs;

    @ApiModelProperty(value = "装备形态")
    public Integer type;

    @ApiModelProperty(value = "装备配用范围")
    public String matchingRangeName;

    @ApiModelProperty(value = "是不是配件(0:不是，1:是)")
    private Integer isPart;


}
