package com.tykj.dev.device.library.utils;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;

public class DeviceNumberUtils {

    public static int extractSeqNumber(DeviceLibrary device){
        String seqString = device.getSeqNumber().substring(device.getSeqNumber().length() - 4);
        return Integer.parseInt(seqString.replace("0", ""));
    }

    /**
     *
     * @param seqString 默认是形如 '0081'这样的字符串
     * @return 0081
     */
    public static int parseSeq2Number(String seqString){
        return Integer.parseInt(seqString.replace("0", ""));
    }

    /**
     *
     * @param seqNumber 形如 35这样的数字
     * @return '0035'
     */
    public static String parseNumber2Seq(int seqNumber){
        String seqString = String.valueOf(seqNumber);
        if (seqString.length() == 1){
            seqString = "000" + seqString;
        }

        if (seqString.length() == 2){
            seqString = "00" + seqString;
        }

        if (seqString.length() == 3){
            seqString = "0" + seqString;
        }

        return seqString;

    }
}
