package com.tykj.dev.device.loss.controller;

import com.tykj.dev.config.swagger.AutoDocument;
import com.tykj.dev.device.loss.service.LossBillSelectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceLossSelectController.java
 * @Description TODO
 * @createTime 2021年01月30日 16:36:00
 */
@RestController
@Api(tags = "装备丢失查询模块", description = "装备丢失查询模块")
@AutoDocument
@RequestMapping("/loss/select")
public class DeviceLossSelectController {
    @Autowired
    LossBillSelectService lossBillSelectService;

    @GetMapping(value ="/findDeviceLoss/{taskId}")
    @ApiOperation(value = "上报上级单位确认接口", notes = "上报上级单位确认接口")
    public ResponseEntity initiateLoss( @PathVariable Integer taskId){
        return ResponseEntity.ok(lossBillSelectService.findDeviceLoss(taskId));
    }



}
