package com.tykj.dev.device.matching.repository;

import com.tykj.dev.device.matching.subject.domin.MatchingDeviceLibrary;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import javax.transaction.Transactional;
import java.util.List;

/**
 * @author dengdiyi
 */
public interface MatchingDeviceLibraryDao extends JpaRepository<MatchingDeviceLibrary, Integer>, JpaSpecificationExecutor<MatchingDeviceLibrary> {

        List<MatchingDeviceLibrary> findAllByModel(String model);

        List<MatchingDeviceLibrary> findAllByCreateUnitId(Integer unitId);

        List<MatchingDeviceLibrary>  findAllByCreateUnitIdIn(List<Integer> unitIds);

        @Transactional
        @Modifying
        @Query("update MatchingDeviceLibrary m set m.createUnit = :updateUnitName where m.createUnit = :originUnitName")
        int updateCreateUnitName(@Param("originUnitName") String originUnitName,
                               @Param("updateUnitName") String updateUnitName);

}
