package com.tykj.dev.device.matching.service;

import com.tykj.dev.device.matching.subject.domin.MatchingDeviceLibrary;
import com.tykj.dev.device.matching.subject.vo.MatchingUnitVo;
import com.tykj.dev.device.matching.subject.vo.MatchingDeviceSelectVo;
import com.tykj.dev.device.matching.subject.vo.RelationDeviceVo;
import com.tykj.dev.rfid.entity.vo.RfidPrintVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;

/**
 * @author dengdiyi
 */
public interface MatchingDeviceLibraryService {

    /**
     * @param matchingDeviceLibraryEntity 添加配套设备
     */
    MatchingDeviceLibrary addEntity(MatchingDeviceLibrary matchingDeviceLibraryEntity);

    /**
     * @param matchingDeviceLibraries 异步上链
     */
    void sendHash(List<MatchingDeviceLibrary> matchingDeviceLibraries);

    /**
     * @param id 通过id查询配套设备
     */
    MatchingDeviceLibrary getOne(Integer id);

    /**
     * @param matchingDeviceLibraryEntity 更新配套设备信息
     */
    MatchingDeviceLibrary update(MatchingDeviceLibrary matchingDeviceLibraryEntity);

    /**
     * @param id 删除配套设备
     */
    void delete(Integer id);

    /**
     * @param matchingDeviceSelectVo 配套设备查询vo
     * @param pageable               配套设备分页查询
     */
    Page<MatchingDeviceLibrary> getPage(MatchingDeviceSelectVo matchingDeviceSelectVo, Pageable pageable);

    /**
     * @param matchingDeviceSelectVo 装备查询vo
     */
    List<MatchingDeviceLibrary> getMatchingDevicePage(MatchingDeviceSelectVo matchingDeviceSelectVo);


    /**
     * @param unitId 单位id
     */
    List<MatchingDeviceLibrary> getMatchingByUnitIdAll(Integer unitId);




    /**
     * @return 所有类型
     */
    List<String> getAllModel();

    /**
     * @return 所有名称
     */
    List<String> getAllName();


    /**
     * 根据型号查询序列号是否是第一次生成
     * @param model 型号
     * @return 返回值是序列号列表
     */
    List<String> findByModelForSeqNumber(String model);

    /**
     * 关联装备
     * @param relationDeviceVo 关联装备的vo
     */
    void  relationDevice(RelationDeviceVo relationDeviceVo);

    /**
     * 获取配套设备的序列号
     */
    Map<String,MatchingDeviceLibrary> getAllMatchingDeviceSeqNumber();

    /**
     * 打印标签
     */
     void printRfid(List<RfidPrintVo> rfid);

    /**
     * 打印或者更新标签
     * @param matchingDeviceId 配套设备的id
     */
    MatchingDeviceLibrary printRfid(Integer matchingDeviceId);

    /**
     * 查询所有的序列号
     * @return
     */
    List<String> getAllMatchingDeviceLibraryListSeqNumberList();

    /**
     * 修改单位名称从而修改配套设备库装备的创建单位的名称
     * @param matchingUnitVo 修改单位名称的vo
     */
    void updateMatchingDeviceCreateUnitNameByUnitName(MatchingUnitVo matchingUnitVo);
}
