package com.tykj.dev.device.matching.subject.domin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * zsp
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update matching_device_model set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@ApiModel("配套设备型号")
public class MatchingDeviceModel {

    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(name = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;

    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "名称")
    private String name;

    /**
     * delete_tag
     */
    @ApiModelProperty(value = "删除标志位")
    private Integer delete_tag = 0;
}
