package com.tykj.dev.device.matching.subject.vo;

import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.matching.subject.domin.MatchingDeviceBill;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配套设备账单存储类")
public class MatchingDeviceBillSaveVo {

    @NotNull(message = "fileName不能为空")
    @ApiModelProperty(value = "确认单附件名")
    private String fileName;

    @NotNull(message = "fileUrl不能为空")
    @ApiModelProperty(value = "确认单附件url")
    private String fileUrl;

    @NotNull(message = "useraId不能为空")
    @Min(value = 1,message = "useraId不能小于1")
    @ApiModelProperty(value = "发起人id")
    private Integer useraId;

//    @NotNull(message = "userbId不能为空")
//    @Min(value = 1,message = "userbId不能小于1")
    @ApiModelProperty(value = "审核人id")
    private Integer userbId;

    private List<FileRet> fileRets;

    @ApiModelProperty(value = "是否打印rfid标签(1:是，0:否)")
    private Integer isPrint = 0;

    @ApiModelProperty(value = "任务id")
    private Integer taskId = 0;

    @Valid
    @NotEmpty(message = "matchingDeviceSaveVoList不能为空")
    @ApiModelProperty(value = "配套设备列表")
    private List<MatchingDeviceSaveVo> matchingDeviceSaveVoList;

    public MatchingDeviceBill toDo() {
        MatchingDeviceBill matchingDeviceBillEntity = new MatchingDeviceBill();
        BeanUtils.copyProperties(this, matchingDeviceBillEntity);
        matchingDeviceBillEntity.setBillStatus(2);
        matchingDeviceBillEntity.setDeviceDetail("x");
        return matchingDeviceBillEntity;
    }
}
