package com.tykj.dev.device.matching.subject.vo;

import com.tykj.dev.device.matching.subject.domin.MatchingDeviceLibrary;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author dengdiyi
 */
@Data
@ApiModel("配套设备存储类")
public class MatchingDeviceSaveVo {

    @NotNull(message = "type不能为空")
    @ApiModelProperty(value = "设备类型")
    private String type;

    @NotNull(message = "model不能为空")
    @ApiModelProperty(value = "型号")
    private String model;

    @NotNull(message = "name不能为空")
    @ApiModelProperty(value = "设备名称")
    private String name;

    @NotNull(message = "name不能为空")
    @ApiModelProperty(value = "形态")
    private String style;

    @NotNull(message = "createUnit不能为空")
    @ApiModelProperty(value = "创建单位")
    private String createUnit;

    @NotNull(message = "createUnitId不能为空")
    @ApiModelProperty(value = "创建单位Id")
    private Integer createUnitId;

    @NotNull(message = "seqNumber不能为空")
    @ApiModelProperty(value = "设备序列号")
    private String seqNumber;

//    @NotNull(message = "rfidSurfaceId不能为空")
    @ApiModelProperty(value = "rfid表面号")
    private String rfidSurfaceId;

//    @NotNull(message = "rfidCardId不能为空")
    @ApiModelProperty(value = "rfid卡号")
    private String rfidCardId = "";

    @ApiModelProperty(value = "入库的数量")
    private Integer storageCount;

    @ApiModelProperty(value = "序列号集合")
    private List<String> seqList;

    @ApiModelProperty(value = "存放位置")
    private String matchingDeviceStorageLocation;

    @ApiModelProperty(value = "存放位置id")
    private Integer matchingDeviceStorageLocationId;

    public MatchingDeviceLibrary toDo() {
        MatchingDeviceLibrary matchingDeviceLibraryEntity = new MatchingDeviceLibrary();
        BeanUtils.copyProperties(this, matchingDeviceLibraryEntity);
        matchingDeviceLibraryEntity.setLifeStatus(2);
        matchingDeviceLibraryEntity.setDeviceId(0);
//        if (matchingDeviceLibraryEntity.getRfidCardId()==null||"".equals(matchingDeviceLibraryEntity.getRfidCardId())){
//            matchingDeviceLibraryEntity.setRfidCardId(UUID.randomUUID().toString());
//        }
        return matchingDeviceLibraryEntity;
    }
}
