package com.tykj.dev.device.matching.subject.vo;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * zsp
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("配套设备序列号vo")
public class MatchingDeviceSeqVo {

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(name = "名称")
    private String name;

    @ApiModelProperty(name = "形态",example = "1")
    private String style;

    @ApiModelProperty(value = "入库数量")
    private Integer storageCount;

    @ApiModelProperty(value = "序列号区间")
    private String seqInterval;

    @ApiModelProperty(value = "序列号集合")
    private List<String> seqList;
}
