package com.tykj.dev.misc.base;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.time.LocalDateTime;

/**
 * BaseVo.
 *
 * @author Matrix <xhyrzldf@gmail.com>
 * @since 2021/9/24 at 11:02 上午
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BaseVo {

    /**
     * 主键id
     */
    private Integer id;

    /**
     * 创建用户id
     */
    private Integer createUserId;

    /**
     * 更新用户id
     */
    private Integer updateUserId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 删除标记(0:未删除，1:已删除)
     */
    private Integer deleteTag = 0;
}
