package com.tykj.dev.misc.base;

import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 维修状态枚举
 */

@AllArgsConstructor
public enum RepairStatusEnum {
    /**
     * 等待维修
     */
    WAIT_REPAIR(0, "等待维修"),
    /**
     * 维修中
     */
    REPAIRING(1, "维修中"),
    /**
     * 待领取
     */
    WAIT_RECEIVE(2, "待领取"),
    /**
     * 库存换新
     */
    CHANGE_NEW(3, "库存换新"),//不用了
    /**
     * 已报废
     */
    SCRAPPED(4, "已报废"),
    /**
     * 已领取入库
     */
    RECEIVED(5, "已领取入库"),
    /**
     * 新装备换新
     */
    CHANGE_NEW_DEVICE(6, "新装备换新"),
    /**
     * 已领取待入库
     */
    RECEIVE_WAIT_STORAGE(7, "已领取待入库"),
    /**
     * 等待上级维修装备送回
     */
    WAIT_BACK(8, "等待上级维修装备送回"),
    /**
     * 等待送修
     */
    WAIT_SEND(9, "等待送修");

    public Integer id;

    public String name;
}
