package com.tykj.dev.misc.base;

import lombok.AllArgsConstructor;

/**
 * @author dengdiyi
 * 业务状态枚举
 */

@AllArgsConstructor
public enum StatusEnum {

    /**
     * 初始状态
     */
    ORIGIN_STATUS(0, "初始状态"),

    /**
     * RFID标签制作
     */
    CREATE_RFID_BUSINESS(8100, "标签制作业务开始"),
    RFID_BUSINESS_NEED_CONFIRM(8101, "等待审核"),

    /**
     * 销毁业务
     */
    DESTROY_0(8110, "装备销毁业务草稿"),
    DESTROY_2(8112, "等待上传销毁单"),



    /**
     * 退装业务
     */
    CREATE_RETIRED_BUSINESS(8120, "退装业务开始"),
    RETIRED_BUSINESS_NEED_CONFIRM(8121, "等待审核"),
    RETIRED_BUSINESS_CONFIRM_FINISH_SUCCESS(8122, "审核成功"),
    RETIRED_BUSINESS_CONFIRM_FINISH_FAILED(8123, "审核失败"),

    /**
     * 核查任务
     */
    //以下为stat状态
    CONFIRM_STAT_0(150,"市统计数据等待确认"),

    CHECK_STAT_0(110, "统计数据收集中"),
    CHECK_STAT_1(111, "统计数据等待确认"),


    //以下为 区自查detail状态
    CHECK_DETAIL_0(120, "等待专管员A处理"),
    CHECK_DETAIL_1(121, "等待专管员B处理"),
    CHECK_DETAIL_2(122, "等待核查员A处理"),

    //以下为检查stat状态
    CHECK_EXAM_STAT_0(130, "检查统计数据收集中"),
    CHECK_EXAM_STAT_1(131, "检查统计数据等待确认"),

    //以下为检查detail状态
    CHECK_DETAIL_REGION_0(140, "等待区专管员A处理"),
    CHECK_DETAIL_REGION_1(141, "等待区专管员B处理"),
    CHECK_DETAIL_REGION_2(142, "等待市专管员审核"),

    // 市本级自查detail状态
    CHECK_DETAIL_CITY_0(160, "等待专管员A处理"),
    CHECK_DETAIL_CITY_1(161, "等待专管员B处理"),

    // 核查任务终止状态
    CHECK_SHUT_DOWN(20001,"任务终止"),

    /**
     * 清退任务
     */
    SEND_BACK_1200(1200, "省清退任务待各市提交"),
    SEND_BACK_1201(1201, "市清退任务待执行"),
    SEND_BACK_1202(1202, "省直属装备待清退"),
    SEND_BACK_1203(1203, "省本级装备待清退"),
    SEND_BACK_1204(1204, "市清退任务待各区提交"),
    SEND_BACK_1205(1205, "区清退任务待执行"),
    SEND_BACK_1206(1206, "等待选择清退装备"),
    SEND_BACK_1207(1207, "清退装备等待审核确认"),
    SEND_BACK_1208(1208, "清退装备等待出库"),
    SEND_BACK_1209(1209, "清退装备等待入库"),
    SEND_BACK_1210(1210, "等待上传退役签收单"),
    SEND_BACK_1211(1211, "市发清退任务待省审核"),
    SEND_BACK_1212(1212, "清退统计任务待办结"),
    SEND_BACK_1213(1213,"省直属清退任务待上传单据"),
    SEND_BACK_1214(1214,"清退出库等待上传回执单"),
    SEND_BACK_1215(1215,"清退接收方单据待补充"),
    SEND_BACK_1216(1216, "市本级装备待清退"),
    SEND_BACK_1217(1217, "出库签章审核"),
    SEND_BACK_1218(1218, "入库等待盖电子签章"),
    SEND_BACK_1219(1219, "出库等待盖电子签章"),
    SEND_BACK_1220(1220, "入库电子签章审核"),

    DECOMMISSIONING_1250(1250, "退役草稿"),
    DECOMMISSIONING_1251(1251, "退役出库签章审核"),
    DECOMMISSIONING_1252(1252, "退役出库等待盖电子签章"),

    LOSS1300(1300,"丢失装备等待市审核"),

    LOSS1301(1301,"丢失装备等待省审核"),


    RETRIEVE1400(1400,"装备找回等待市审核"),

    RETRIEVE1401(1401,"装备找回等待省审核"),

    RETRIEVE1402(1402,"装备找回市审核不通过"),

    RETRIEVE1403(1403,"装备找回省审核不通过"),


//    SEND_BACK_1204(1204, "入库待审核"),


    /**
     * 业务完结
     */
    END(9999, "业务完结"),

    TRAIN1000(1000, "报名中"),

    TRAIN1001(1001, "报名确认"),

    TRAIN1002(1002, "待报名"),

    TRAIN1003(1003, "等待培训"),

    TRAIN1004(1004, "培训中"),

    TRAIN1005(1005, "申请发证"),

    TRAIN1006(1006, "市培训申请发证审核"),

    TRAIN1007(1007, "培训等待发证"),

    TRAIN1008(1008, "成绩录入"),

    TRAIN1009(1009, "成绩确认"),

    TRAIN1010(1010, "待培训"),

    TRAIN1012(1012, "线上培训课题待学习"),

    TRAIN1013(1013, "试卷待批阅"),

    TRAIN1014(1014, "待线上考试"),

    TRAIN1015(1015, "待批阅试卷"),

    TRAIN1016(1016, "待继续报名"),

    TRAIN1017(1017, "待重新报名"),

    WORKHANDOVER1011(1011, "待上传签字单"),


    /**
     * 中止业务状态
     */
    SUSPENSION1500(1500,"待市级确认"),

    /**
     * 中止业务状态
     */
    SUSPENSION1501(1501,"待省级确认"),


    /**
     * 业务封存
     */
    ARCHIVE(8888, "业务封存"),

    /**
     * 配发任务撤回
     */
    REVOKEALLOTTASK(20000, "任务撤回"),

    /**
     * 列装待审核
     */
    PACKING_CONFIRM(100, "列装待审核"),

    /**
     * 入库待审核
     */
    STORAGE_CONFIRM(200, "入库待审核"),
    WAIT_STORAGE(201, "草稿"),
    /**
     * 待配发
     */
    WAIT_ALLOT(300, "待配发"),

    /**
     * 配发出库待审核
     */
    ALLOT_SEND_CONFIRM(301, "配发出库待审核"),

    /**
     * 配发中
     */
    ALLOTING(302, "配发中"),

    /**
     * 待上传配发单
     */
    WAIT_UPLOAD_ALLOT_RECEIVE_FILE(303, "待上传签收单"),

    /**
     * 待上传横向配发单
     */
    WAIT_UPLOAD_CROSS_FILE(311,"待上传回执单"),

    /**
     * 待上传纵向配发单
     */
    WAIT_UPLOAD_ALLOT_FILE(322,"待上传回执单"),

    /**
     * 草稿
     */
    ALLOT_DRAFT(333,"草稿"),

    /**
     * 申请签章待审核
     */
    SIGN_WAIT_CONFIRM(340,"申请签章待审核"),

    /**
     * 待盖章出库
     */
    WAIT_SIGN(341,"等待盖章"),

    /**
     * 待自查
     */
    WAIT_SELF_CHECK(400, "待自查"),

    /**
     * 待上传自查单
     */
    SELF_CHECK_CONFIRM(401, "待上传自查单"),

    /**
     * 装备申请待批复
     */
    DEVICE_APPLY_CONFIRM(500, "装备申请待批复"),

    /**
     * 等待上传申请回执单
     */
    WAIT_APPLY_FILE(510, "待上传批复单"),
    /**
     * 等待上传申请回执单
     */
    WAIT_CONFIRM_APPLY_DEVICE(511, "批复完成待执行"),

    /**
     * 业务待办结
     */
    WAITAPPLYTASKTOEND(512,"申请任务待办结"),


//    /**
//     * 等待上传申请回执单
//     */
//    WAIT_APPLY_FILE(520, "待上传申请回执单"),

    /**
     * 新增配套设备待审核
     */
    ADD_MATCHING_DEVICE_CONFIRM(600, "新增配套设备待审核"),

    /**
     * 维修送修状态
     */
    REPAIR_SEND_CONFIRM(700, "维修送修出库待审核"),

    WAIT_RECEIVE(701, "等待接收维修装备"),
    REPAIR_RECEIVE_CONFIRM(702, "接收维修装备待审核"),
    REPAIRING(703, "维修中"),
    WAIT_UPLOAD_FILE(704, "等待上传签收单"),
    WAIT_UPLOAD_SEND_FILE(722, "等待上传回执单"),
    COUNTRY_REPAIRING(777, "等待接收维修退回装备"),
    REPAIR_SEND_DRAFT(788,"等待出库"),
    REPAIR_SEND_SIGN_WAIT_CONFIRM(790,"申请签章待审核"),
    REPAIR_SEND_WAIT_SIGN(791,"等待盖章"),
    REPAIR_SEND_UNDER_DRAFT(799,"省直属等待出库"),
    /**
     * 维修完成退回状态
     */
    REPAIR_BACK_CONFIRM(800, "维修退回装备出库待审核"),
    WAIT_BACK_RECEIVE(801, "等待接收维修退回装备"),
    REPAIR_BACK_RECEIVE_CONFIRM(802, "接收维修退回装备待审核"),
    WAIT_UPLOAD_BACK_FILE(804, "等待上传签收单"),
    WAIT_UPLOAD_BACK_SEND_FILE(810, "等待上传回执单"),
    REPAIR_BACK_SIGN_WAIT_CONFIRM(820,"申请签章待审核"),
    REPAIR_BACK_WAIT_SIGN(821,"等待盖章"),
    REPAIR_BACK_DRAFT(888,"等待出库"),
    REPAIR_BACK_UNDER_DRAFT(889,"省直属等待出库"),

    /**
     * 配发退回状态
     */
    WAIT_BACK(899, "待配发退回"),
    ALLOT_BACKING(900, "装备退回中"),
    WAIT_UPLOAD_ALLOT_BACK_FILE(901, "待上传签收单"),
    WAIT_UPLOAD_BACK_FILE_2(911, "待上传回执单"),
    BACK_DRAFT(922,"草稿"),
    BACK_SIGN_WAIT_CONFIRM(930,"申请签章待审核"),
    BACK_WAIT_SIGN(931,"等待盖章"),
    BACK_UNDER_DRAFT(932,"等待省直属退回"),
    /**
     * 报废状态
     */
    SCRAP_2222(2222, "等待上传报废签收单"),
    SCRAP_2223(2223, "报废草稿"),
    SCRAP_2224(2224, "报废出库签章审核"),
    SCRAP_2225(2225, "报废出库等待盖电子签章");

    public Integer id;

    public String name;
}
