package com.tykj.dev.misc.utils;

import com.tykj.dev.misc.exception.ApiException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceModelSort.java
 * @Description TODO
 * @createTime 2021年07月14日 13:45:00
 */
@Component
@Slf4j
public class DeviceModelSort {
    public static Map<String, Integer> mapModelSort;

    public static Map<String, Integer> mapUnitSort;

    public static Map<String,String> mapUnitNameToDisName;


    /**
     * 根据单位名称换单位的简称
     */
    public static String unitNameToDisName(String unitName){
        if (mapUnitNameToDisName.containsKey(unitName)){
            return mapUnitNameToDisName.get(unitName);
        }else {
//            throw new ApiException("没有找到对应的单位名称替换简称："+unitName);
            return unitName;
        }
    }

    /**
     * 列装型号排序方法
     *
     * @param modelList 需要排序的型号
     * @return 排】序过后的型号列表
     */
    public static List<String> modelToSort(List<String> modelList) {
        return modelList.stream()
                .map(s -> new SortedModel(toModelSort(s), s))
                .sorted(Comparator.comparing(SortedModel::getId).thenComparing(SortedModel::getValue))
                .map(SortedModel::getValue)
                .collect(Collectors.toList());
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    static
    class SortedModel {
        Integer id;
        String value;
    }


    /**
     * 获取型号对应的排序号
     *
     * @param model 型号
     * @return 排序号码
     */
    public static Integer toModelSort(String model) {
      Integer sort=  mapModelSort.get(model);
        if(sort == null){
            sort = 9999;
        }
        return sort;
    }

    /**
     * 单位排序排序方法
     *
     * @param unitList 需要排序的型号
     * @return 排序过后的型号列表
     */
    public static List<String> unitToSort(List<String> unitList) {
        return unitList.stream()
                .map(s -> new SortedModel(toUnitSort(s), s))
                .sorted(Comparator.comparing(SortedModel::getId).thenComparing(SortedModel::getValue))
                .map(SortedModel::getValue)
                .collect(Collectors.toList());
    }

    /**
     * 获取单位对应的排序号
     *
     * @param unitName 单位名称
     * @return 排序号码
     */
    public static Integer toUnitSort(String unitName) {
        if (mapUnitSort.containsKey(unitName)){
            return mapUnitSort.get(unitName);
        }else {
            log.info("单位名称没找到排序：{}",unitName);
            return 9999;
        }
    }

}
