package com.tykj.dev.device.packing.repository;

import com.tykj.dev.device.packing.subject.domin.PackingLibrary;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author dengdiyi
 */
public interface PackingLibraryDao extends JpaRepository<PackingLibrary, Integer>, JpaSpecificationExecutor<PackingLibrary> {

    List<PackingLibrary> findAllByPartParentId(Integer id);

    List<PackingLibrary> findAllByPartParentIdAndPackingStatus(Integer id,Integer packingId);

    List<PackingLibrary> findAllByIdIn(List<Integer> ids);

    PackingLibrary findByShowOrder(Integer showOrder);

    PackingLibrary findByShowOrderAndModelNot(Integer showOrder,String model);

    List<PackingLibrary> findAllByIsRootAndPackingStatus(Integer isRoot,Integer packingStatus);

    List<PackingLibrary> findAllByPartParentIdAndMatchingRangeAndPackingStatusAndName(Integer partParentId,Integer matchingRange,Integer packingStatus,String name);
    List<PackingLibrary> findAllByPartParentIdAndMatchingRangeAndPackingStatusInAndName(Integer partParentId,Integer matchingRange,List<Integer> packingStatus,String name);

    /**
     * zsp
     */
    List<PackingLibrary> findAllByPartParentIdAndMatchingRangeAndPackingStatusAndNameAndDeleteTag(Integer partParentId,Integer matchingRange,Integer packingStatus,String name,Integer del);

    List<PackingLibrary> findAllByDeleteTag(Integer deleteTag);

    PackingLibrary findByDeleteTagAndIdAndPackingStatus(Integer deleteTag,Integer id,Integer packingStatus);

    List<PackingLibrary> findByInvisibleRangeAndTypeAndName(Integer invisibleRange,Integer type,String name);

    /**
     *
     */
    List<PackingLibrary> findAllByPartParentIdAndPackingStatusIn(Integer partParentId,List<Integer> status);

    /**
     * 根据型号取出目录
     */
    List<PackingLibrary> findAllByModelInAndIsRootAndPackingStatus(List<String> models,Integer isRoot,Integer packingStatus);

    /**
     * 根据型号查出所有
     */
    List<PackingLibrary> findAllByModel(String model);

    /**
     *
     */
    @Query("select max(o.showOrder) from PackingLibrary o")
    int maxShowOrder();

    @Query(value = "select p.showOrder from PackingLibrary p where p.showOrder between :beginShowOrder and :endShowOrder ")
    List<Integer> selectShowOrders(@Param("beginShowOrder") Integer beginShowOrder,@Param("endShowOrder") Integer endShowOrder);

    List<PackingLibrary> findByShowOrderIn(List<Integer> showOrders);

    @Transactional
    @Modifying
    @Query("update PackingLibrary p set p.showOrder = p.showOrder+1 where p in (:packingLibraries)")
    void updateShowOrders(@Param("packingLibraries") List<PackingLibrary> packingLibraries);

    @Query("select p.showOrder from PackingLibrary p")
    List<Integer> selectAllShowOrders();

    /**
     * 解绑需要用到
     */
    @Transactional
    @Modifying
    @Query("update PackingLibrary  p set p.partParentId = :partParentId where p.id in :packingIds")
    List<PackingLibrary> updatePartParentId(@Param("partParentId") Integer partParentId,
                                            @Param("packingIds") List<Integer> packingIds);
}

