package com.tykj.dev.device.packing.subject.domin;

import com.tykj.dev.config.cache.ConfigCache;
import com.tykj.dev.device.file.entity.FileRet;
import com.tykj.dev.device.file.service.FilesUtil;
import com.tykj.dev.misc.utils.SpringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * entity class for packing_library
 * 列装库
 */
@Data
@Entity
@ApiModel("列装库")
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update packing_library set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
public class PackingLibrary {

    @Transient
    List<PackingLibrary> childs = new ArrayList<>();
    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @ApiModelProperty(value = "主键id")
    @Column(columnDefinition = "integer NOT NULL AUTO_INCREMENT")
    private Integer id;
    /**
     * 经办人省A岗id
     */
    @ApiModelProperty(value = "经办人省A岗id")
    private Integer useraId;
    /**
     * 审核人省B岗id
     */
    @ApiModelProperty(value = "审核人省B岗id")
    private Integer userbId;
    /**
     * 是不是配件(0:不是，1:是)
     */
    @ApiModelProperty(value = "是不是配件(0:不是，1:是)")
    private Integer isPart;

    @ApiModelProperty(value = "是不是目录(0:不是，1:是)")
    private Integer isRoot;

    @ApiModelProperty(value = "排序号")
    private Integer showOrder;

    @ApiModelProperty(value = "类型")
    private Integer style;
    /**
     * 配件对应装备列装id
     */
    @ApiModelProperty(value = "配件对应装备列装id")
    private Integer partParentId;
    /**
     * 列装状态(0:待审核,1:审核失败,2:已列装,3:已退装,4:退装待审核)
     */
    @ApiModelProperty(value = "列装状态(0:待审核,1:审核失败,2:已列装,3:已退装,4:已删除)")
    private Integer packingStatus;
    /**
     * 型号
     */
    @ApiModelProperty(value = "型号")
    private String model;
    /**
     * 密级
     */
    @ApiModelProperty(value = "密级")
    private Integer secretLevel;
    /**
     * 名称
     */
    @ApiModelProperty(value = "名称")
    private String name;
    /**
     * 应用类型
     */
    @ApiModelProperty(value = "应用类型")
    private Integer applyType;
    /**
     * 配用范围
     */
    @ApiModelProperty(value = "配用范围",notes = "1 省以下纵向 2 中央到省 3 省以下横向 4 其他")
    private Integer matchingRange;
    /**
     * 可见范围
     */
    @ApiModelProperty(value = "可见范围")
    private Integer invisibleRange;
    /**
     * 形态
     */
    @ApiModelProperty(value = "形态")
    private Integer type;
    /**
     * 列装性质
     */
    @ApiModelProperty(value = "列装性质")
    private Integer nature;
    /**
     * 列装状态
     */
    @ApiModelProperty(value = "列装状态")
    private Integer status;
    /**
     * 生产单位
     */
    @ApiModelProperty(value = "生产单位")
    private String prodUnit;
    /**
     * 创建单位
     */
    @ApiModelProperty(value = "创建单位")
    private String createUnit;
    /**
     * 价格
     */
    @ApiModelProperty(value = "价格")
    private String price;
    /**
     * 图片名称
     */
    @ApiModelProperty(value = "图片名称")
    private String imageName;
    /**
     * 图片url地址
     */
    @Column(name = "image_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "图片url地址")
    private String imageUrl;
    /**
     * 附件名称
     */
    @ApiModelProperty(value = "附件名称")
    private String fileName;

    @ApiModelProperty(value = "装备存放位置",notes = "默认是库房")
    private String storageLocation;

    /**
     * 附件Db
     */
    @ApiModelProperty(value = "附件名称")
    @Column(name = "file_db",columnDefinition = "TEXT")
    private String fileDb;

    /**
     * 附件名称集合
     */
    @Transient
    @ApiModelProperty(value = "附件名称")
    private List<FileRet> fileList;

    /**
     * 附件url地址
     */
    @Column(name = "file_url",columnDefinition = "TEXT")
    @ApiModelProperty(value = "附件url地址")
    private String fileUrl;
    /**
     * 退装时间
     */
    @ApiModelProperty(value = "退装时间")
    private Date exitTime;


    @ApiModelProperty(value = "区块链记录id")
    private String recordId;
    /**
     * 创建用户id
     */
    @CreatedBy
    @ApiModelProperty(value = "创建用户id")
    private Integer createUserId;
    /**
     * 创建时间
     */
    @CreatedDate
    @ApiModelProperty(name = "创建时间")
    private Date createTime;
    /**
     * 更新用户id
     */
    @LastModifiedBy
    @ApiModelProperty(value = "更新用户id")
    private Integer updateUserId;
    /**
     * 更新时间
     */
    @LastModifiedDate
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    /**
     * 删除标记(0:未删除，1:已删除)
     */
    @ApiModelProperty(value = "删除标记(0:未删除，1:已删除)")
    private Integer deleteTag = 0;

    @ApiModelProperty(value = "列装描述")
//    @Lob
    @Column(name = "description",columnDefinition = "TEXT")
    private String description;
    /**
     * 装备和配件对应关系 相同的是一套设备
     */
    @Transient
    private Integer corresponding;

    @ApiModelProperty(value = "经办人省A岗")
    @Transient
    private String userA;
    @ApiModelProperty(value = "审核人省B岗")
    @Transient
    private String userB;
    @ApiModelProperty(value = "申请数量")
    @Transient
    private Integer applyNum;

    @ApiModelProperty(value = "可批复数量(只做展示)")
    @Transient
    private Integer replyNum;

    @ApiModelProperty(value = "待入库数量")
    @Transient
    private Integer waitNum;
    @ApiModelProperty(value = "已入库数量")
    @Transient
    private Integer completeNum;
    @ApiModelProperty(value = "预分配的装备序列号")
    @Transient
    private String seq;
    @ApiModelProperty(value = "预分配的生产序列号")
    @Transient
    private String prodNumber;

    @ApiModelProperty(value = "密级")
    @Transient
    private String secretLevelName;

    @ApiModelProperty(value = "应用类型")
    @Transient
    private String applyTypeName;

    @ApiModelProperty(value = "配用范围")
    @Transient
    private String matchingRangeName;

    @ApiModelProperty(value = "可见范围")
    @Transient
    private String invisibleRangeName;

    @ApiModelProperty(value = "形态")
    @Transient
    private String typeName;

    @ApiModelProperty(value = "列装性质")
    @Transient
    private String natureName;


    @Transient
    private Integer devNum;

    @Transient
    @ApiModelProperty(value = "是不是单独的配件,0-不是,1-是")
    private Integer isSinglePart;

    @Transient
    @ApiModelProperty(value = "装备的数量")
    private Integer deviceNum;

    @Transient
    @ApiModelProperty(value = "装备id的集合")
    private List<Integer> deviceIds;

    @Transient
    @ApiModelProperty(value = "序号")
    private Integer seqOrderNumber;

    @Transient
    @ApiModelProperty(value = "试用装备的序列号")
    private List<String> deviceSeqNumberList;

    @Transient
    @ApiModelProperty(value = "等级")
    private Integer level;


    public void addChildNode(PackingLibrary packingLibraryEntity) {
        childs.add(packingLibraryEntity);
    }

    public void setChildNull() {
        this.childs=null;
    }



    public PackingLibrary setConfigName(){
        ConfigCache configCache = SpringUtils.getBean("initConfigCache");
        if (configCache != null) {
            setSecretLevelName(configCache.getSecretLevelMap().get(this.secretLevel)==null?"-":configCache.getSecretLevelMap().get(this.secretLevel));
            setApplyTypeName(configCache.getApplyTypeMap().get(this.applyType)==null?"-":configCache.getApplyTypeMap().get(this.applyType));
            setMatchingRangeName(configCache.getMatchingRangeMap().get(this.matchingRange)==null?"-":configCache.getMatchingRangeMap().get(this.matchingRange));
            setInvisibleRangeName(configCache.getInvisibleRangeMap().get(this.invisibleRange)==null?"-":configCache.getInvisibleRangeMap().get(this.invisibleRange));
            setTypeName(configCache.getStyleMap().get(this.type)==null?"-":configCache.getStyleMap().get(this.type));
            setNatureName(configCache.getNatureMap().get(this.nature)==null?"-":configCache.getNatureMap().get(this.nature));
        }
        setFileList(FilesUtil.stringFileToList(this.getFileDb()));
        return this;
    }
}
